/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import com.googlecode.solrgeonames.server.OpenSearchResponse;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDetailResponse
implements OpenSearchResponse {
    private static Logger log = LoggerFactory.getLogger(HtmlDetailResponse.class);

    public void init(HttpServletRequest request) {
    }

    public String renderResponse(QueryResponse results) {
        String output = "";
        for (SolrDocument doc : results.getResults()) {
            output = output + this.renderRow(doc);
        }
        return output;
    }

    private String renderRow(SolrDocument doc) {
        String output = "<p>";
        for (String key : doc.keySet()) {
            Object object = doc.getFieldValue(key);
            String value = null;
            if (object instanceof String) {
                value = (String)doc.getFieldValue(key);
            }
            if (object instanceof Integer) {
                value = String.valueOf((Integer)doc.getFieldValue(key));
            }
            if (object instanceof Float) {
                value = String.valueOf((Float)doc.getFieldValue(key));
            }
            if (object instanceof Long) {
                value = String.valueOf((Long)doc.getFieldValue(key));
            }
            if (object instanceof Date) {
                value = ((Date)object).toString();
            }
            output = output + "<b>" + key + "</b>: " + value + "<br/>";
        }
        output = output + "</p>";
        return output;
    }

    public String renderEmptyResponse() {
        return "Error, invalid ID";
    }

    public String renderError(String message) {
        return "Error: " + message;
    }

    public String contentType() {
        return "text/html";
    }
}

