/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import com.googlecode.solrgeonames.server.OpenSearchResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlSearchResponse
implements OpenSearchResponse {
    private static Logger log = LoggerFactory.getLogger(HtmlSearchResponse.class);

    public void init(HttpServletRequest request) {
    }

    public String renderResponse(QueryResponse results) {
        String output = "";
        for (SolrDocument doc : results.getResults()) {
            output = output + this.renderRow(doc);
        }
        return output;
    }

    private String renderRow(SolrDocument doc) {
        String id = (String)doc.getFieldValue("id");
        String name = (String)doc.getFieldValue("basic_name");
        String country = (String)doc.getFieldValue("country_code");
        String timezone = (String)doc.getFieldValue("timezone");
        String score = String.valueOf((Float)doc.getFieldValue("score"));
        return "<b><a href='/geonames/search?func=detail&amp;id=" + id + "'>" + name + "</a></b>, " + country + " (" + timezone + ")<br/>";
    }

    public String renderEmptyResponse() {
        return "Boo, 0 results";
    }

    public String renderError(String message) {
        return "Error: " + message;
    }

    public String contentType() {
        return "text/html";
    }
}

