/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import com.googlecode.solrgeonames.server.HtmlDebugResponse;
import com.googlecode.solrgeonames.server.HtmlDetailResponse;
import com.googlecode.solrgeonames.server.HtmlSearchResponse;
import com.googlecode.solrgeonames.server.JsonDetailResponse;
import com.googlecode.solrgeonames.server.JsonSearchResponse;
import com.googlecode.solrgeonames.server.OpenSearchResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(GeoServlet.class);
    public static String DEFAULT_START = "0";
    public static String DEFAULT_ROWS = "20";
    private EmbeddedSolrServer solrServer;

    public void init() throws ServletException {
        Object object = this.getServletContext().getAttribute("solr");
        if (object != null && object instanceof EmbeddedSolrServer) {
            this.solrServer = (EmbeddedSolrServer)object;
        } else {
            this.solrServer = null;
            log.error("Error accessing Solr from context");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String function = request.getParameter("func");
        if (function != null) {
            if (function.equals("detail")) {
                this.detail(request, response);
                return;
            }
            if (function.equals("search") || function.equals("debug")) {
                this.search(request, response);
                return;
            }
        }
        OpenSearchResponse renderer = this.getRenderer(request);
        response.setStatus(400);
        response.setContentType(renderer.contentType());
        PrintWriter out = response.getWriter();
        out.println(renderer.renderError("No 'func' parameter was supplied"));
        out.close();
    }

    private void detail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter out = resp.getWriter();
        OpenSearchResponse renderer = this.getRenderer(req);
        resp.setContentType(renderer.contentType());
        String id = req.getParameter("id");
        if (id == null || id.equals("")) {
            resp.setStatus(400);
            out.println(renderer.renderError("A detail query requires an 'id' parameter."));
            out.close();
            return;
        }
        QueryResponse result = null;
        try {
            result = this.runQuery("id:" + id, 0, 1, "*,score", null, null, 0);
        }
        catch (Exception ex) {
            resp.setStatus(500);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            out.println(renderer.renderError("An error occurred searching:\n" + sw.toString()));
            out.close();
            return;
        }
        if (result.getResults().isEmpty()) {
            resp.setStatus(404);
            out.println(renderer.renderEmptyResponse());
        } else {
            out.println(renderer.renderResponse(result));
        }
        out.close();
    }

    private void search(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String start;
        PrintWriter out = resp.getWriter();
        OpenSearchResponse renderer = this.getRenderer(req);
        resp.setContentType(renderer.contentType());
        String q = req.getParameter("q");
        String query = null;
        if (q == null || q.equals("")) {
            query = "boost:boost^10";
        }
        if (query == null) {
            query = this.buildWeightedQuery(q.toLowerCase());
        }
        if ((start = req.getParameter("start")) == null || start.equals("")) {
            start = DEFAULT_START;
        }
        int iStart = Integer.valueOf(start);
        String rows = req.getParameter("rows");
        if (rows == null || rows.equals("")) {
            rows = DEFAULT_ROWS;
        }
        int iRows = Integer.valueOf(rows);
        QueryResponse result = null;
        try {
            String func = req.getParameter("func");
            if (func.equals("debug")) {
                String[] facets = new String[]{"country_code", "feature_class", "feature_code"};
                String fq = req.getParameter("fq");
                result = this.runQuery(query, iStart, iRows, "*,score", fq, facets, 100);
            } else {
                String fq = req.getParameter("fq");
                result = this.runQuery(query, iStart, iRows, "*,score", fq, null, 0);
            }
        }
        catch (Exception ex) {
            resp.setStatus(500);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            out.println(renderer.renderError("An error occurred searching:\n" + sw.toString()));
            out.close();
            return;
        }
        if (result.getResults().isEmpty()) {
            out.println(renderer.renderEmptyResponse());
        } else {
            out.println(renderer.renderResponse(result));
        }
        out.close();
    }

    private QueryResponse runQuery(String query, int start, int rows, String fields, String filter, String[] facets, int facetLimit) throws Exception {
        SolrQuery q = new SolrQuery();
        q.setQuery(query);
        q.setStart(Integer.valueOf(start));
        q.setRows(Integer.valueOf(rows));
        q.setFields(new String[]{fields});
        if (filter != null) {
            q.setFilterQueries(new String[]{filter});
        }
        if (facets != null) {
            q.setFacet(true);
            q.setFacetLimit(facetLimit);
            q.addFacetField(facets);
        } else {
            q.setFacet(false);
        }
        return this.solrServer.query((SolrParams)q);
    }

    private String buildWeightedQuery(String q) {
        String rev = new StringBuffer(q).reverse().toString();
        String both = "(basic_name_str:(" + q + "*) AND basic_name_rev:(" + rev + "*))";
        String left = "(basic_name_str:(" + q + "*))";
        String name = "(basic_name:(" + q + "*) OR basic_name:(" + q + "))";
        String boost = "boost:boost^10";
        return "(" + both + "^10 OR " + left + "^4 OR " + name + ")^0.2" + " AND " + boost;
    }

    private OpenSearchResponse getRenderer(HttpServletRequest request) {
        String function = request.getParameter("func");
        String format = request.getParameter("format");
        if (format != null && format.equals("json")) {
            if (function != null && function.equals("detail")) {
                JsonDetailResponse renderer = new JsonDetailResponse();
                renderer.init(request);
                return renderer;
            }
            JsonSearchResponse renderer = new JsonSearchResponse();
            renderer.init(request);
            return renderer;
        }
        if (function != null && function.equals("detail")) {
            HtmlDetailResponse renderer = new HtmlDetailResponse();
            renderer.init(request);
            return renderer;
        }
        if (function != null && function.equals("debug")) {
            HtmlDebugResponse renderer = new HtmlDebugResponse();
            renderer.init(request);
            return renderer;
        }
        HtmlSearchResponse renderer = new HtmlSearchResponse();
        renderer.init(request);
        return renderer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }
}

