/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import com.googlecode.solrgeonames.server.OpenSearchResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDetailResponse
implements OpenSearchResponse {
    private static Logger log = LoggerFactory.getLogger(JsonDetailResponse.class);

    public void init(HttpServletRequest request) {
    }

    public String renderResponse(QueryResponse results) {
        SolrDocumentList list = results.getResults();
        ArrayList<String> rows = new ArrayList<String>();
        for (SolrDocument doc : list) {
            rows.add(this.renderRow(doc));
        }
        if (list.size() == 1) {
            return (String)rows.get(0);
        }
        String joined = this.join(rows, ",\n");
        return "[\n" + joined + "\n]";
    }

    private String join(List<String> list, String separator) {
        String output = "";
        for (String element : list) {
            if (!output.equals("")) {
                output = output + separator;
            }
            output = output + element;
        }
        return output;
    }

    private String renderRow(SolrDocument doc) {
        String output = "";
        for (String key : doc.keySet()) {
            if (!output.equals("")) {
                output = output + ",\n";
            }
            Object object = doc.getFieldValue(key);
            String value = null;
            if (object instanceof String) {
                value = (String)doc.getFieldValue(key);
            }
            if (object instanceof Integer) {
                value = String.valueOf((Integer)doc.getFieldValue(key));
            }
            if (object instanceof Float) {
                value = String.valueOf((Float)doc.getFieldValue(key));
            }
            if (object instanceof Long) {
                value = String.valueOf((Long)doc.getFieldValue(key));
            }
            if (object instanceof Date) {
                value = ((Date)object).toString();
            }
            key = key.replace("\"", "\\\"");
            value = value.replace("\"", "\\\"");
            output = output + "\"" + key + "\": \"" + value + "\"";
        }
        return "{\n" + output + "\n}";
    }

    public String renderEmptyResponse() {
        return "{\"Error\": \"ID not found\"}";
    }

    public String renderError(String message) {
        message = message.replace("\"", "\\\"");
        message = message.replace("\\", "\\\\");
        return "{\"Error\": \"" + message + "\"}";
    }

    public String contentType() {
        return "application/json";
    }
}

