/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.solrgeonames.server;

import com.googlecode.solrgeonames.server.GeoServlet;
import com.googlecode.solrgeonames.server.OpenSearchResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSearchResponse
implements OpenSearchResponse {
    private static Logger log = LoggerFactory.getLogger(JsonSearchResponse.class);
    private HttpServletRequest request;

    public void init(HttpServletRequest request) {
        this.request = request;
    }

    public String renderResponse(QueryResponse results) {
        return "{\n" + this.headResponse(results) + ",\n" + this.listResponse(results) + "\n}";
    }

    public String renderEmptyResponse() {
        return "{\n" + this.headResponse(null) + ",\n\"results\": []\n}";
    }

    private String headResponse(QueryResponse results) {
        String rows;
        String start = this.request.getParameter("start");
        if (start == null || start.equals("")) {
            start = GeoServlet.DEFAULT_START;
        }
        if ((rows = this.request.getParameter("rows")) == null || rows.equals("")) {
            rows = GeoServlet.DEFAULT_ROWS;
        }
        String inner = this.escape("title", "Generic Search") + ",\n";
        if (results == null) {
            inner = inner + this.escape("totalResults", "0") + ",\n";
        } else {
            SolrDocumentList list = results.getResults();
            inner = inner + this.escape("totalResults", list.getNumFound()) + ",\n";
        }
        inner = inner + this.escape("startIndex", start) + ",\n";
        inner = inner + this.escape("itemsPerPage", rows) + "\n";
        return "\"OpenSearchResponse\": {\n" + inner + "\n}";
    }

    private String listResponse(QueryResponse results) {
        SolrDocumentList list = results.getResults();
        ArrayList<String> rows = new ArrayList<String>();
        for (SolrDocument doc : list) {
            rows.add(this.renderRow(doc));
        }
        String joined = this.join(rows, ",\n");
        return "\"results\": [\n" + joined + "\n]";
    }

    private String join(List<String> list, String separator) {
        String output = "";
        for (String element : list) {
            if (!output.equals("")) {
                output = output + separator;
            }
            output = output + element;
        }
        return output;
    }

    private String renderRow(SolrDocument doc) {
        String output = "";
        for (String key : doc.keySet()) {
            if (!output.equals("")) {
                output = output + ",\n";
            }
            Object object = doc.getFieldValue(key);
            String value = null;
            if (object instanceof String) {
                value = (String)doc.getFieldValue(key);
            }
            if (object instanceof Integer) {
                value = String.valueOf((Integer)doc.getFieldValue(key));
            }
            if (object instanceof Float) {
                value = String.valueOf((Float)doc.getFieldValue(key));
            }
            if (object instanceof Long) {
                value = String.valueOf((Long)doc.getFieldValue(key));
            }
            if (object instanceof Date) {
                value = ((Date)object).toString();
            }
            output = output + this.escape(key, value);
            if (!key.equals("id")) continue;
            output = output + ",\n" + this.escape("geonames_uri", "http://sws.geonames.org/" + value + "/");
        }
        String name = (String)doc.getFieldValue("basic_name");
        String country = (String)doc.getFieldValue("country_code");
        String timezone = (String)doc.getFieldValue("timezone");
        String display = name + ", " + country + " (" + timezone + ")";
        output = output + ",\n" + this.escape("display", display);
        return "{\n" + output + "\n}";
    }

    private String escape(String key, long value) {
        return this.escape(key, String.valueOf(value));
    }

    private String escape(String key, String value) {
        key = key.replace("\"", "\\\"");
        key = key.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("\\", "\\\\");
        return "\"" + key + "\": \"" + value + "\"";
    }

    public String renderError(String message) {
        message = message.replace("\"", "\\\"");
        message = message.replace("\\", "\\\\");
        return "{\"Error\": \"" + message + "\"}";
    }

    public String contentType() {
        return "application/json";
    }
}

