/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.cdda.cdparanoia;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.lowlevel.cdda.CddaMidLevel;
import org.tritonus.lowlevel.cdda.cdparanoia.Cdparanoia;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class CdparanoiaMidLevel
implements CddaMidLevel {
    private static int PCM_FRAMES_PER_CDDA_FRAME = 588;
    private static AudioFormat CDDA_FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);

    public CdparanoiaMidLevel() {
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.<init>(): begin");
        }
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.<init>(): end");
        }
    }

    public Iterator getDevices() {
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.getDevices(): begin");
        }
        String[] astrDevices = new String[]{"/dev/cdrom"};
        List<String> devicesList = Arrays.asList(astrDevices);
        Iterator<String> iterator = devicesList.iterator();
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.getDevices(): end");
        }
        return iterator;
    }

    public String getDefaultDevice() {
        return "/dev/cdrom";
    }

    public InputStream getTocAsXml(String strDevice) throws IOException {
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.getTocAsXML(): begin");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        int[] anValues = new int[2];
        int[] anStartFrame = new int[100];
        int[] anLength = new int[100];
        int[] anType = new int[100];
        boolean[] abAudio = new boolean[100];
        boolean[] abCopy = new boolean[100];
        boolean[] abPre = new boolean[100];
        int[] anChannels = new int[100];
        Cdparanoia cdparanoia = new Cdparanoia(strDevice);
        cdparanoia.readTOC(anValues, anStartFrame, anLength, anType, abAudio, abCopy, abPre, anChannels);
        int nTracks = anValues[1] - anValues[0] + 1;
        out.println("<tracklist>");
        for (int i = 0; i < nTracks; ++i) {
            out.print("<track");
            out.print(" id=\"" + (i + anValues[0]) + "\"");
            out.print(" start=\"" + anStartFrame[i] + "\"");
            out.print(" length=\"" + anLength[i] + "\"");
            out.print(" type=\"" + anType[i] + "\"");
            out.print(" audio=\"" + abAudio[i] + "\"");
            out.print(" copy=\"" + abCopy[i] + "\"");
            out.print(" pre=\"" + abPre[i] + "\"");
            out.print(" channels=\"" + anChannels[i] + "\" />\n");
        }
        out.println("</tracklist>");
        byte[] abData = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(abData);
        cdparanoia.close();
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.getTocAsXML(): end");
        }
        return bais;
    }

    public AudioInputStream getTrack(String strDevice, int nTrack) throws IOException {
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.getInputStream(): begin");
        }
        CddaAudioInputStream audioInputStream = new CddaAudioInputStream(strDevice, nTrack);
        if (TDebug.TraceCdda) {
            TDebug.out("CdparanoiaMidLevel.getInputStream(): end");
        }
        return audioInputStream;
    }

    private class CddaAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private static final int BUFFER_SIZE = 2352;
        private Cdparanoia m_cdparanoia;
        private int m_nCddaFrameCount;
        private int m_nStartFrame;
        private int m_nEndFrame;
        private int m_nLengthCount;
        private byte[] m_abData;
        private int m_nTrack;

        public CddaAudioInputStream(String strDevice, int nTrack) {
            super(CDDA_FORMAT, -1L);
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.<init>(): begin");
            }
            this.m_nTrack = nTrack;
            int[] anValues = new int[2];
            int[] anStartFrame = new int[100];
            int[] anLength = new int[100];
            int[] anType = new int[100];
            boolean[] abAudio = new boolean[100];
            boolean[] abCopy = new boolean[100];
            boolean[] abPre = new boolean[100];
            int[] anChannels = new int[100];
            this.m_cdparanoia = new Cdparanoia(strDevice);
            this.m_cdparanoia.readTOC(anValues, anStartFrame, anLength, anType, abAudio, abCopy, abPre, anChannels);
            this.m_nCddaFrameCount = 0;
            int nTrackIndex = this.getTrack() - anValues[0];
            this.m_nStartFrame = anStartFrame[nTrackIndex];
            this.m_abData = new byte[2352];
            this.m_nLengthCount = anLength[nTrackIndex];
            this.frameLength = this.m_nLengthCount * PCM_FRAMES_PER_CDDA_FRAME;
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.<init>(): track length in cdda frames: " + this.m_nLengthCount);
            }
            this.m_cdparanoia.prepareTrack(this.getTrack());
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.<init>(): end");
            }
        }

        private long getTrackLengthInPcmFrames() {
            int nCddaFrames = this.getTrackLengthInCddaFrames();
            long lLength = nCddaFrames * PCM_FRAMES_PER_CDDA_FRAME;
            return lLength;
        }

        private int getTrackLengthInCddaFrames() {
            int nLength = this.getEndFrame() - this.getStartFrame() + 1;
            return nLength;
        }

        private int getStartFrame() {
            return this.m_nStartFrame;
        }

        private int getEndFrame() {
            return this.m_nEndFrame;
        }

        private int getTrack() {
            return this.m_nTrack;
        }

        private int getCurrentFrameNumber() {
            return this.m_nCddaFrameCount + this.m_nStartFrame;
        }

        private void increaseCurrentFrameNumber() {
            ++this.m_nCddaFrameCount;
        }

        private boolean isEndOfTrackReached() {
            return this.m_nLengthCount == 0;
        }

        public void execute() {
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.execute(): begin");
            }
            if (!this.isEndOfTrackReached()) {
                if (TDebug.TraceCdda) {
                    TDebug.out("CddaAudioInputStream.execute(): begin");
                }
                while (this.getCircularBuffer().availableWrite() >= 2352 && !this.isEndOfTrackReached()) {
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): before readFrame()");
                    }
                    this.m_cdparanoia.readNextFrame(1, this.m_abData);
                    --this.m_nLengthCount;
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): length count now: " + this.m_nLengthCount);
                    }
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): after readFrame(), before cb.write()");
                    }
                    this.getCircularBuffer().write(this.m_abData, 0, 2352);
                    if (TDebug.TraceCdda) {
                        TDebug.out("CddaAudioInputStream.execute(): after cb.write()");
                    }
                    this.increaseCurrentFrameNumber();
                }
            } else {
                if (TDebug.TraceCdda) {
                    TDebug.out("CddaAudioInputStream.execute(): end of cdda track");
                }
                this.getCircularBuffer().close();
            }
            if (TDebug.TraceCdda) {
                TDebug.out("CddaAudioInputStream.execute(): end");
            }
        }

        public void close() throws IOException {
            this.m_cdparanoia.close();
            super.close();
        }
    }
}

