/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.java;

import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import org.tritonus.midi.device.java.SunMiscPerfClock;
import org.tritonus.midi.device.java.SystemCurrentTimeMillisClock;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;
import org.tritonus.share.midi.TSequencer;

public class JavaSequencer
extends TSequencer
implements Runnable {
    private static final Sequencer.SyncMode[] MASTER_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static final Sequencer.SyncMode[] SLAVE_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTING = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_STOPPING = 3;
    private static final int STATE_CLOSING = 4;
    private Thread m_thread;
    private long m_lMicroSecondsPerTick;
    private int[] m_anTrackPositions;
    private long m_lTickPosition;
    private long m_lStartTime;
    private int m_nPhase;
    private boolean m_bTempoChanged;
    private Clock m_clock;
    private long m_lSleepInterval;

    public JavaSequencer(MidiDevice.Info info) {
        super(info, Arrays.asList(MASTER_SYNC_MODES), Arrays.asList(SLAVE_SYNC_MODES));
        String strVersion;
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.<init>(): begin");
        }
        if ((strVersion = System.getProperty("java.version")).indexOf("1.4.2") != -1) {
            this.setClock(new SunMiscPerfClock());
        } else {
            this.setClock(new SystemCurrentTimeMillisClock());
        }
        String strOS = System.getProperty("os.name");
        this.m_lSleepInterval = strOS.equals("Linux") ? 0L : 1L;
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.<init>(): end");
        }
    }

    protected void openImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.openImpl(): begin");
        }
        this.m_nPhase = 0;
        this.m_thread = new Thread(this);
        this.m_thread.setPriority(10);
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.openImpl(): starting thread");
        }
        this.m_thread.start();
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.openImpl(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.closeImpl(): begin");
        }
        this.stop();
        JavaSequencer javaSequencer = this;
        synchronized (javaSequencer) {
            this.m_nPhase = 4;
            this.notifyAll();
        }
        this.m_thread = null;
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.closeImpl(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.startImpl(): begin");
        }
        JavaSequencer javaSequencer = this;
        synchronized (javaSequencer) {
            if (this.m_nPhase == 0) {
                this.m_nPhase = 1;
                this.notifyAll();
                while (this.m_nPhase == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(e);
                    }
                }
            }
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.startImpl(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.stopImpl(): begin");
        }
        JavaSequencer javaSequencer = this;
        synchronized (javaSequencer) {
            if (Thread.currentThread() == this.m_thread) {
                if (this.m_nPhase != 0) {
                    this.m_nPhase = 0;
                    this.notifyAll();
                }
            } else if (this.m_nPhase == 2) {
                this.m_nPhase = 3;
                while (this.m_nPhase == 3) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(e);
                    }
                }
            }
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.stopImpl(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.run(): begin");
        }
        while (true) {
            JavaSequencer javaSequencer = this;
            synchronized (javaSequencer) {
                while (this.m_nPhase == 0) {
                    if (TDebug.TraceSequencer) {
                        TDebug.out("JavaSequencer.run(): waiting to become running");
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(e);
                    }
                }
                if (this.m_nPhase == 4) {
                    if (TDebug.TraceSequencer) {
                        TDebug.out("JavaSequencer.run(): end");
                    }
                    return;
                }
                if (TDebug.TraceSequencer) {
                    TDebug.out("JavaSequencer.run(): now running");
                }
                this.m_lStartTime = this.getTimeInMicroseconds() - this.m_lTickPosition * this.m_lMicroSecondsPerTick;
                this.m_nPhase = 2;
                this.notifyAll();
            }
            Sequence sequence = this.getSequence();
            if (sequence == null) {
                this.stop();
                continue;
            }
            Track[] aTracks = sequence.getTracks();
            while (this.m_nPhase == 2) {
                JavaSequencer javaSequencer2;
                long lTick;
                boolean bTrackPresent = false;
                long lBestTick = Long.MAX_VALUE;
                int nBestTrack = -1;
                for (int nTrack = 0; nTrack < aTracks.length; ++nTrack) {
                    if (this.m_anTrackPositions[nTrack] >= aTracks[nTrack].size() || !this.isTrackEnabled(nTrack)) continue;
                    bTrackPresent = true;
                    MidiEvent event = aTracks[nTrack].get(this.m_anTrackPositions[nTrack]);
                    lTick = event.getTick();
                    if (lTick >= lBestTick) continue;
                    lBestTick = lTick;
                    nBestTrack = nTrack;
                }
                if (!bTrackPresent) {
                    MetaMessage metaMessage;
                    block31: {
                        metaMessage = new MetaMessage();
                        try {
                            metaMessage.setMessage(47, new byte[0], 0);
                        }
                        catch (InvalidMidiDataException e) {
                            if (!TDebug.TraceAllExceptions) break block31;
                            TDebug.out(e);
                        }
                    }
                    if (TDebug.TraceSequencer) {
                        TDebug.out("JavaSequencer.run(): sending End of Track message with tick " + (this.m_lTickPosition + 1L));
                    }
                    this.deliverEvent(metaMessage, this.m_lTickPosition + 1L);
                    this.stop();
                    break;
                }
                MidiEvent event = aTracks[nBestTrack].get(this.m_anTrackPositions[nBestTrack]);
                MidiMessage message = event.getMessage();
                lTick = event.getTick();
                if (message instanceof MetaMessage && ((MetaMessage)message).getType() == 47) {
                    if (TDebug.TraceSequencer) {
                        TDebug.out("JavaSequencer.run(): ignoring End of Track message with tick " + lTick);
                    }
                    int n = nBestTrack;
                    this.m_anTrackPositions[n] = this.m_anTrackPositions[n] + 1;
                    javaSequencer2 = this;
                    synchronized (javaSequencer2) {
                        this.m_lTickPosition = lTick;
                        continue;
                    }
                }
                if (this.deliverEvent(message, lTick)) {
                    int n = nBestTrack;
                    this.m_anTrackPositions[n] = this.m_anTrackPositions[n] + 1;
                    javaSequencer2 = this;
                    synchronized (javaSequencer2) {
                        this.m_lTickPosition = lTick;
                        continue;
                    }
                }
                javaSequencer2 = this;
                synchronized (javaSequencer2) {
                    this.m_lTickPosition = Math.min(lTick, (this.getTimeInMicroseconds() - this.m_lStartTime) / this.m_lMicroSecondsPerTick);
                }
            }
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliverEvent(MidiMessage message, long lScheduledTick) {
        MetaMessage metaMessage;
        long lScheduledTime;
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.deliverEvent(): begin");
        }
        JavaSequencer javaSequencer = this;
        synchronized (javaSequencer) {
            lScheduledTime = lScheduledTick * this.m_lMicroSecondsPerTick + this.m_lStartTime;
        }
        while (this.getTimeInMicroseconds() < lScheduledTime) {
            if (this.m_nPhase != 2) {
                return false;
            }
            if (this.m_bTempoChanged) {
                javaSequencer = this;
                synchronized (javaSequencer) {
                    lScheduledTime = lScheduledTick * this.m_lMicroSecondsPerTick + this.m_lStartTime;
                    this.m_bTempoChanged = false;
                }
            }
            try {
                Thread.sleep(this.m_lSleepInterval);
            }
            catch (InterruptedException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        if (message instanceof MetaMessage && (metaMessage = (MetaMessage)message).getType() == 81) {
            byte[] abData = metaMessage.getData();
            int nTempo = MidiUtils.getUnsignedInteger(abData[0]) * 65536 + MidiUtils.getUnsignedInteger(abData[1]) * 256 + MidiUtils.getUnsignedInteger(abData[2]);
            this.setTempoInMPQ(nTempo);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.deliverEvent(): sending message: " + message + " at: " + lScheduledTime);
        }
        this.sendImpl(message, -1L);
        this.notifyListeners(message);
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.deliverEvent(): end");
        }
        return true;
    }

    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    public void setSequence(Sequence sequence) throws InvalidMidiDataException {
        boolean bWasRunning = this.isRunning();
        if (bWasRunning) {
            this.stop();
        }
        super.setSequence(sequence);
        this.m_lTickPosition = 0L;
        this.m_anTrackPositions = new int[sequence.getTracks().length];
        for (int i = 0; i < this.m_anTrackPositions.length; ++i) {
            this.m_anTrackPositions[i] = 0;
        }
        if (bWasRunning) {
            this.start();
        }
    }

    public void setMicrosecondPosition(long lPosition) {
        this.setTickPosition(lPosition / this.m_lMicroSecondsPerTick);
    }

    public void setTickPosition(long lPosition) {
        if (this.getSequence() == null || this.m_anTrackPositions == null) {
            return;
        }
        boolean bWasRunning = this.isRunning();
        if (bWasRunning) {
            this.stop();
        }
        this.m_lTickPosition = lPosition > this.getSequence().getTickLength() ? this.getSequence().getTickLength() : lPosition;
        for (int i = 0; i < this.m_anTrackPositions.length; ++i) {
            this.m_anTrackPositions[i] = this.getTrackPosition(this.getSequence().getTracks()[i], lPosition);
        }
        if (bWasRunning) {
            this.start();
        }
    }

    public synchronized long getTickPosition() {
        if (this.m_nPhase == 2) {
            return Math.max(this.m_lTickPosition, (this.getTimeInMicroseconds() - this.m_lStartTime) / this.m_lMicroSecondsPerTick);
        }
        return this.m_lTickPosition;
    }

    public void recordDisable(Track track) {
    }

    public void recordEnable(Track track) {
    }

    public void recordEnable(Track track, int nChannel) {
    }

    public boolean isRecording() {
        return false;
    }

    public void stopRecording() {
        this.checkOpen();
    }

    public void startRecording() {
        this.checkOpen();
    }

    protected synchronized void setTempoImpl(float fMPQ) {
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.setTempoImpl(): begin");
        }
        int nResolution = this.getResolution();
        long currentTime = this.getTimeInMicroseconds();
        long currentTickPosition = 0L;
        if (this.m_lMicroSecondsPerTick != 0L) {
            currentTickPosition = (currentTime - this.m_lStartTime) / this.m_lMicroSecondsPerTick;
        }
        this.m_lMicroSecondsPerTick = (long)fMPQ / (long)nResolution;
        this.m_lStartTime = currentTime - currentTickPosition * this.m_lMicroSecondsPerTick;
        this.m_bTempoChanged = true;
        if (TDebug.TraceSequencer) {
            TDebug.out("JavaSequencer.setTempoImpl(): end");
        }
    }

    private int getTrackPosition(Track track, long tickPosition) {
        if (track.size() == 0 || tickPosition <= track.get(0).getTick()) {
            return 0;
        }
        if (tickPosition > track.get(track.size() - 1).getTick()) {
            return track.size();
        }
        int idx1 = 0;
        int idx2 = track.size() - 1;
        while (idx2 - idx1 != 1) {
            int idx3 = (int)(((long)idx1 + (long)idx2) / 2L);
            if (tickPosition > track.get(idx3).getTick()) {
                idx1 = idx3;
                continue;
            }
            idx2 = idx3;
        }
        return idx1;
    }

    protected long getTimeInMicroseconds() {
        if (this.getClock() == null) {
            return 0L;
        }
        return this.getClock().getMicroseconds();
    }

    public void setClock(Clock clock) {
        if (this.isOpen()) {
            throw new IllegalStateException("closed state required to set the clock");
        }
        this.m_clock = clock;
    }

    public Clock getClock() {
        return this.m_clock;
    }

    public static interface Clock {
        public long getMicroseconds();
    }
}

