/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.pvorbis;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.lowlevel.pogg.Packet;
import org.tritonus.lowlevel.pogg.Page;
import org.tritonus.lowlevel.pogg.StreamState;
import org.tritonus.lowlevel.pogg.SyncState;
import org.tritonus.lowlevel.pvorbis.Block;
import org.tritonus.lowlevel.pvorbis.Comment;
import org.tritonus.lowlevel.pvorbis.DspState;
import org.tritonus.lowlevel.pvorbis.Info;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;

public class VorbisFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final AudioFormat.Encoding VORBIS = new AudioFormat.Encoding("VORBIS");
    private static final AudioFormat.Encoding PCM_SIGNED = new AudioFormat.Encoding("PCM_SIGNED");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true), new AudioFormat(VORBIS, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VORBIS, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(VORBIS, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VORBIS, -1.0f, -1, 2, -1, -1.0f, true)};
    private static final boolean DEFAULT_VBR = true;
    private static final float DEFAULT_QUALITY = 0.5f;
    private static final int DEFAULT_MAX_BITRATE = 256;
    private static final int DEFAULT_NOM_BITRATE = 128;
    private static final int DEFAULT_MIN_BITRATE = 32;

    public VorbisFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(INPUT_FORMATS));
        if (TDebug.TraceAudioConverter) {
            TDebug.out("VorbisFormatConversionProvider.<init>(): begin");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("VorbisFormatConversionProvider.<init>(): end");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">VorbisFormatConversionProvider.getAudioInputStream(): begin");
        }
        TAsynchronousFilteredAudioInputStream convertedAudioInputStream = null;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("checking if conversion supported");
            TDebug.out("from: " + audioInputStream.getFormat());
            TDebug.out("to: " + targetFormat);
        }
        if (this.isConversionSupported(targetFormat = this.getDefaultTargetFormat(targetFormat, audioInputStream.getFormat()), audioInputStream.getFormat())) {
            if (targetFormat.getEncoding().equals(VORBIS)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("conversion supported; trying to create EncodedVorbisAudioInputStream");
                }
                convertedAudioInputStream = new EncodedVorbisAudioInputStream(targetFormat, audioInputStream);
            } else {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("conversion supported; trying to create DecodedVorbisAudioInputStream");
                }
                convertedAudioInputStream = new DecodedVorbisAudioInputStream(targetFormat, audioInputStream);
            }
        } else {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<conversion not supported; throwing IllegalArgumentException");
            }
            throw new IllegalArgumentException("conversion not supported");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<VorbisFormatConversionProvider.getAudioInputStream(): end");
        }
        return convertedAudioInputStream;
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat targetFormat, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("VorbisFormatConversionProvider.getDefaultTargetFormat(): target format: " + targetFormat);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("VorbisFormatConversionProvider.getDefaultTargetFormat(): source format: " + sourceFormat);
        }
        AudioFormat newTargetFormat = null;
        for (AudioFormat format : this.getCollectionTargetFormats()) {
            if (!AudioFormats.matches(targetFormat, format)) continue;
            newTargetFormat = format;
        }
        if (newTargetFormat == null) {
            throw new IllegalArgumentException("conversion not supported");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("VorbisFormatConversionProvider.getDefaultTargetFormat(): new target format: " + newTargetFormat);
        }
        newTargetFormat = new AudioFormat(targetFormat.getEncoding(), sourceFormat.getSampleRate(), newTargetFormat.getSampleSizeInBits(), newTargetFormat.getChannels(), newTargetFormat.getFrameSize(), sourceFormat.getSampleRate(), newTargetFormat.isBigEndian(), targetFormat.properties());
        if (TDebug.TraceAudioConverter) {
            TDebug.out("VorbisFormatConversionProvider.getDefaultTargetFormat(): really new target format: " + newTargetFormat);
        }
        return newTargetFormat;
    }

    public static class DecodedVorbisAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private static final int INPUT_BUFFER_SIZE = 4096;
        private static final int BUFFER_MULTIPLE = 4;
        private static final int BUFFER_SIZE = 2048;
        private static final int CONVSIZE = 4096;
        private InputStream m_oggBitStream = null;
        private byte[] m_abInputBuffer;
        private SyncState m_oggSyncState = null;
        private StreamState m_oggStreamState = null;
        private Page m_oggPage = null;
        private Packet m_oggPacket = null;
        private Info m_vorbisInfo = null;
        private Comment m_vorbisComment = null;
        private DspState m_vorbisDspState = null;
        private Block m_vorbisBlock = null;
        private int convsize = -1;
        private byte[] convbuffer = new byte[4096];
        private float[][] m_aPcmOut;
        private boolean m_bHeadersExpected;

        public DecodedVorbisAudioInputStream(AudioFormat outputFormat, AudioInputStream bitStream) {
            super(outputFormat, -1L);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedVorbisAudioInputStream.<init>(): begin");
            }
            this.m_oggBitStream = bitStream;
            this.m_bHeadersExpected = true;
            this.init_jorbis();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedVorbisAudioInputStream.<init>(): end");
            }
        }

        private void init_jorbis() {
            this.m_abInputBuffer = new byte[4096];
            this.m_oggSyncState = new SyncState();
            this.m_oggStreamState = new StreamState();
            this.m_oggPage = new Page();
            this.m_oggPacket = new Packet();
            this.m_vorbisInfo = new Info();
            this.m_vorbisComment = new Comment();
            this.m_vorbisDspState = new DspState();
            this.m_vorbisBlock = new Block();
            this.m_vorbisBlock.init(this.m_vorbisDspState);
            this.m_oggSyncState.init();
        }

        public void execute() {
            if (TDebug.TraceAudioConverter) {
                TDebug.out(">DecodedVorbisAudioInputStream.execute(): begin");
            }
            if (this.m_bHeadersExpected) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("reading headers...");
                }
                try {
                    this.readHeaders();
                }
                catch (IOException e) {
                    if (TDebug.TraceAllExceptions) {
                        TDebug.out(e);
                    }
                    this.closePhysicalStream();
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("<DecodedVorbisAudioInputStream.execute(): end");
                    }
                    return;
                }
                this.m_bHeadersExpected = false;
                this.setupVorbisStructures();
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("decoding...");
            }
            while (this.writeMore()) {
                try {
                    this.readOggPacket();
                }
                catch (IOException e) {
                    if (TDebug.TraceAllExceptions) {
                        TDebug.out(e);
                    }
                    this.closePhysicalStream();
                    this.m_vorbisInfo.free();
                    this.m_vorbisComment.free();
                    this.m_vorbisDspState.free();
                    this.m_vorbisBlock.free();
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("<DecodedVorbisAudioInputStream.execute(): end");
                    }
                    return;
                }
                this.decodeDataPacket();
            }
            if (this.m_oggPacket.isEos()) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("end of vorbis stream reached");
                }
                this.m_oggStreamState.clear();
                this.m_vorbisBlock.clear();
                this.m_vorbisDspState.clear();
                this.m_vorbisInfo.clear();
                this.m_bHeadersExpected = true;
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<DecodedVorbisAudioInputStream.execute(): end");
            }
        }

        private void closePhysicalStream() {
            block5: {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("DecodedVorbisAudioInputStream.closePhysicalStream(): begin");
                }
                this.m_oggSyncState.clear();
                try {
                    if (this.m_oggBitStream != null) {
                        this.m_oggBitStream.close();
                    }
                    this.getCircularBuffer().close();
                }
                catch (Exception e) {
                    if (!TDebug.TraceAllExceptions) break block5;
                    TDebug.out(e);
                }
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedVorbisAudioInputStream.closePhysicalStream(): end");
            }
        }

        private void readHeaders() throws IOException {
            this.readIdentificationHeader();
            this.readCommentAndCodebookHeaders();
            this.processComments();
        }

        private void readIdentificationHeader() throws IOException {
            this.readOggPage();
            this.m_oggStreamState.init(this.m_oggPage.getSerialNo());
            this.m_vorbisInfo.init();
            this.m_vorbisComment.init();
            if (this.m_oggStreamState.pageIn(this.m_oggPage) < 0) {
                throw new IOException("can't read first page of Ogg bitstream data, perhaps stream version mismatch");
            }
            if (this.m_oggStreamState.packetOut(this.m_oggPacket) != 1) {
                throw new IOException("can't read initial header packet");
            }
            if (this.m_vorbisInfo.headerIn(this.m_vorbisComment, this.m_oggPacket) < 0) {
                throw new IOException("packet is not a vorbis header");
            }
        }

        private void readCommentAndCodebookHeaders() throws IOException {
            for (int i = 0; i < 2; ++i) {
                this.readOggPacket();
                if (this.m_vorbisInfo.headerIn(this.m_vorbisComment, this.m_oggPacket) >= 0) continue;
                throw new IOException("packet is not a vorbis header");
            }
        }

        private void processComments() {
            TDebug.out("DecodedVorbisAudioInputStream.processComments(): begin");
            TDebug.out("DecodedVorbisAudioInputStream.processComments(): encoded by: " + this.m_vorbisComment.getVendor());
            String[] astrComments = this.m_vorbisComment.getUserComments();
            TDebug.out("user comments:");
            for (int i = 0; i < astrComments.length; ++i) {
                TDebug.out(astrComments[i]);
            }
            TDebug.out("DecodedVorbisAudioInputStream.processComments(): end");
        }

        private void setupVorbisStructures() {
            this.convsize = 2048 / this.m_vorbisInfo.getChannels();
            this.m_vorbisDspState.initSynthesis(this.m_vorbisInfo);
            this.m_vorbisBlock.init(this.m_vorbisDspState);
            this.m_aPcmOut = new float[this.m_vorbisInfo.getChannels()][];
        }

        private void decodeDataPacket() {
            int nSamples;
            if (this.m_vorbisBlock.synthesis(this.m_oggPacket) == 0) {
                this.m_vorbisDspState.blockIn(this.m_vorbisBlock);
            }
            while ((nSamples = this.m_vorbisDspState.pcmOut(this.m_aPcmOut)) > 0) {
                for (int nChannel = 0; nChannel < this.m_vorbisInfo.getChannels(); ++nChannel) {
                    int pointer = nChannel * this.getSampleSizeInBytes();
                    for (int j = 0; j < nSamples; ++j) {
                        float fVal = this.m_aPcmOut[nChannel][j];
                        this.clipAndWriteSample(fVal, pointer);
                        pointer += this.getFrameSize();
                    }
                }
                this.m_vorbisDspState.read(nSamples);
                this.getCircularBuffer().write(this.convbuffer, 0, this.getFrameSize() * nSamples);
            }
        }

        private void clipAndWriteSample(float fSample, int nPointer) {
            if (fSample > 1.0f) {
                fSample = 1.0f;
            }
            if (fSample < -1.0f) {
                fSample = -1.0f;
            }
            switch (this.getFormat().getSampleSizeInBits()) {
                case 16: {
                    int nSample = (int)(fSample * 32767.0f);
                    if (this.isBigEndian()) {
                        this.convbuffer[nPointer++] = (byte)(nSample >> 8);
                        this.convbuffer[nPointer] = (byte)(nSample & 0xFF);
                        break;
                    }
                    this.convbuffer[nPointer++] = (byte)(nSample & 0xFF);
                    this.convbuffer[nPointer] = (byte)(nSample >> 8);
                    break;
                }
                case 24: {
                    int nSample = (int)(fSample * 8388607.0f);
                    if (this.isBigEndian()) {
                        this.convbuffer[nPointer++] = (byte)(nSample >> 16);
                        this.convbuffer[nPointer++] = (byte)(nSample >>> 8 & 0xFF);
                        this.convbuffer[nPointer] = (byte)(nSample & 0xFF);
                        break;
                    }
                    this.convbuffer[nPointer++] = (byte)(nSample & 0xFF);
                    this.convbuffer[nPointer++] = (byte)(nSample >>> 8 & 0xFF);
                    this.convbuffer[nPointer] = (byte)(nSample >> 16);
                    break;
                }
                case 32: {
                    int nSample = (int)(fSample * 2.1474836E9f);
                    if (this.isBigEndian()) {
                        this.convbuffer[nPointer++] = (byte)(nSample >> 24);
                        this.convbuffer[nPointer++] = (byte)(nSample >>> 16 & 0xFF);
                        this.convbuffer[nPointer++] = (byte)(nSample >>> 8 & 0xFF);
                        this.convbuffer[nPointer] = (byte)(nSample & 0xFF);
                        break;
                    }
                    this.convbuffer[nPointer++] = (byte)(nSample & 0xFF);
                    this.convbuffer[nPointer++] = (byte)(nSample >>> 8 & 0xFF);
                    this.convbuffer[nPointer++] = (byte)(nSample >>> 16 & 0xFF);
                    this.convbuffer[nPointer] = (byte)(nSample >> 24);
                }
            }
        }

        private void readOggPacket() throws IOException {
            do {
                int result;
                if ((result = this.m_oggStreamState.packetOut(this.m_oggPacket)) == 1) {
                    return;
                }
                if (result == -1) {
                    throw new IOException("can't read packet");
                }
                this.readOggPage();
            } while (this.m_oggStreamState.pageIn(this.m_oggPage) >= 0);
            throw new IOException("can't read page of Ogg bitstream data");
        }

        private void readOggPage() throws IOException {
            int result;
            while ((result = this.m_oggSyncState.pageOut(this.m_oggPage)) != 1) {
                int nBytes = this.readFromStream(this.m_abInputBuffer, 0, this.m_abInputBuffer.length);
                if (nBytes == -1) {
                    throw new EOFException();
                }
                this.m_oggSyncState.write(this.m_abInputBuffer, nBytes);
            }
            return;
        }

        private int readFromStream(byte[] buffer, int nStart, int nLength) throws IOException {
            return this.m_oggBitStream.read(buffer, nStart, nLength);
        }

        private int getSampleSizeInBytes() {
            return this.getFormat().getFrameSize() / this.getFormat().getChannels();
        }

        private int getFrameSize() {
            return this.getFormat().getFrameSize();
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_oggBitStream.close();
        }
    }

    public static class EncodedVorbisAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private static final int READ = 1024;
        private AudioInputStream m_decodedStream;
        private byte[] m_abReadbuffer;
        private StreamState m_streamState;
        private Page m_page;
        private Packet m_packet;
        private Info m_info;
        private Comment m_comment;
        private DspState m_dspState;
        private Block m_block;
        private boolean eos = false;

        public EncodedVorbisAudioInputStream(AudioFormat outputFormat, AudioInputStream inputStream) {
            super(outputFormat, -1L, 262144, 16384);
            int result;
            if (TDebug.TraceAudioConverter) {
                TDebug.out(">EncodedVorbisAudioInputStream.<init>(): begin");
            }
            this.m_decodedStream = inputStream;
            this.m_abReadbuffer = new byte[1024 * this.getFrameSize()];
            Object property = null;
            property = outputFormat.getProperty("vbr");
            boolean bUseVBR = true;
            if (property instanceof Boolean) {
                bUseVBR = (Boolean)property;
            }
            property = outputFormat.getProperty("quality");
            float fQuality = 0.5f;
            if (property instanceof Integer) {
                fQuality = (float)((Integer)property).intValue() / 10.0f;
            }
            property = outputFormat.getProperty("bitrate");
            int nNominalBitrate = 128;
            if (property instanceof Integer) {
                nNominalBitrate = (Integer)property / 1024;
            }
            property = outputFormat.getProperty("vorbis.min_bitrate");
            int nMinBitrate = 32;
            if (property instanceof Integer) {
                nMinBitrate = (Integer)property / 1024;
            }
            property = outputFormat.getProperty("vorbis.max_bitrate");
            int nMaxBitrate = 256;
            if (property instanceof Integer) {
                nMaxBitrate = (Integer)property / 1024;
            }
            this.m_streamState = new StreamState();
            this.m_page = new Page();
            this.m_packet = new Packet();
            this.m_info = new Info();
            this.m_comment = new Comment();
            this.m_dspState = new DspState();
            this.m_block = new Block();
            this.m_info.init();
            int nSampleRate = (int)inputStream.getFormat().getSampleRate();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("sample rate: " + nSampleRate);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("channels: " + this.getChannels());
            }
            if (bUseVBR) {
                this.m_info.encodeInitVBR(this.getChannels(), nSampleRate, fQuality);
            } else {
                this.m_info.encodeInit(this.getChannels(), nSampleRate, nMaxBitrate, nNominalBitrate, nMinBitrate);
            }
            this.m_comment.init();
            this.m_comment.addTag("ENCODER", "Tritonus libvorbis wrapper");
            property = outputFormat.getProperty("vorbis.comments");
            if (property instanceof List) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("VorbisFormatConversionProvider.<init>(): comments present in target format");
                }
                List comments = (List)property;
                for (int i = 0; i < comments.size(); ++i) {
                    Object comm = comments.get(i);
                    if (!(comm instanceof String)) continue;
                    this.m_comment.addComment((String)comm);
                }
            }
            this.m_dspState.initAnalysis(this.m_info);
            this.m_block.init(this.m_dspState);
            Random random = new Random(System.currentTimeMillis());
            this.m_streamState.init(random.nextInt());
            Packet header = new Packet();
            Packet header_comm = new Packet();
            Packet header_code = new Packet();
            this.m_dspState.headerOut(this.m_comment, header, header_comm, header_code);
            this.m_streamState.packetIn(header);
            this.m_streamState.packetIn(header_comm);
            this.m_streamState.packetIn(header_code);
            while ((result = this.m_streamState.flush(this.m_page)) != 0) {
                this.getCircularBuffer().write(this.m_page.getHeader());
                this.getCircularBuffer().write(this.m_page.getBody());
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<EncodedVorbisAudioInputStream.<init>(): end");
            }
        }

        public void execute() {
            block26: {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out(">EncodedVorbisAudioInputStream.execute(): begin");
                }
                int nFrameSize = this.getFrameSize();
                int nChannels = this.getChannels();
                boolean bBigEndian = this.isBigEndian();
                int nBytesPerSample = nFrameSize / nChannels;
                int nSampleSizeInBits = nBytesPerSample * 8;
                float fScale = (float)Math.pow(2.0, nSampleSizeInBits - 1);
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("frame size: " + nFrameSize);
                    TDebug.out("channels: " + nChannels);
                    TDebug.out("big endian: " + bBigEndian);
                    TDebug.out("sample size (bits): " + nSampleSizeInBits);
                    TDebug.out("bytes per sample: " + nBytesPerSample);
                    TDebug.out("scale: " + fScale);
                }
                while (!this.eos && this.writeMore()) {
                    int bytes;
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("writeMore(): " + this.writeMore());
                    }
                    try {
                        bytes = this.m_decodedStream.read(this.m_abReadbuffer);
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("read from PCM stream: " + bytes);
                        }
                    }
                    catch (IOException e) {
                        block25: {
                            if (TDebug.TraceAllExceptions || TDebug.TraceAudioConverter) {
                                TDebug.out(e);
                            }
                            this.m_streamState.clear();
                            this.m_block.clear();
                            this.m_dspState.clear();
                            this.m_comment.clear();
                            this.m_info.clear();
                            try {
                                this.close();
                            }
                            catch (IOException e1) {
                                if (!TDebug.TraceAllExceptions && !TDebug.TraceAudioConverter) break block25;
                                TDebug.out(e1);
                            }
                        }
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("<");
                        }
                        return;
                    }
                    if (bytes == 0 || bytes == -1) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("EOS reached; calling DspState.write(0)");
                        }
                        this.m_dspState.write(null, 0);
                    } else {
                        int nFrames = bytes / nFrameSize;
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("processing frames: " + nFrames);
                        }
                        float[][] buffer = new float[nChannels][1024];
                        for (int i = 0; i < nFrames; ++i) {
                            for (int nChannel = 0; nChannel < nChannels; ++nChannel) {
                                int nSample = EncodedVorbisAudioInputStream.bytesToInt16(this.m_abReadbuffer, i * nFrameSize + nChannel * nBytesPerSample, bBigEndian);
                                buffer[nChannel][i] = (float)nSample / fScale;
                            }
                        }
                        this.m_dspState.write(buffer, nFrames);
                    }
                    while (this.m_dspState.blockOut(this.m_block) == 1) {
                        this.m_block.analysis(null);
                        this.m_block.addBlock();
                        while (this.m_dspState.flushPacket(this.m_packet) != 0) {
                            int result;
                            this.m_streamState.packetIn(this.m_packet);
                            while (!this.eos && (result = this.m_streamState.pageOut(this.m_page)) != 0) {
                                this.getCircularBuffer().write(this.m_page.getHeader());
                                this.getCircularBuffer().write(this.m_page.getBody());
                                if (!this.m_page.isEos()) continue;
                                this.eos = true;
                                if (!TDebug.TraceAudioConverter) continue;
                                TDebug.out("page has detected EOS");
                            }
                        }
                    }
                }
                if (this.eos) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("EOS; shutting down encoder");
                    }
                    this.m_streamState.clear();
                    this.m_block.clear();
                    this.m_dspState.clear();
                    this.m_comment.clear();
                    this.m_info.clear();
                    this.getCircularBuffer().close();
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        if (!TDebug.TraceAllExceptions && !TDebug.TraceAudioConverter) break block26;
                        TDebug.out(e);
                    }
                }
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<EncodedVorbisAudioInputStream.execute(): end");
            }
        }

        private int getChannels() {
            return this.m_decodedStream.getFormat().getChannels();
        }

        private int getFrameSize() {
            return this.m_decodedStream.getFormat().getFrameSize();
        }

        private boolean isBigEndian() {
            return this.m_decodedStream.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_decodedStream.close();
        }

        private static int bytesToInt16(byte[] buffer, int byteOffset, boolean bigEndian) {
            return bigEndian ? buffer[byteOffset] << 8 | buffer[byteOffset + 1] & 0xFF : buffer[byteOffset + 1] << 8 | buffer[byteOffset] & 0xFF;
        }
    }
}

