/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.WaveAudioOutputStream;
import org.tritonus.sampled.file.WaveTool;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TAudioFileWriter;
import org.tritonus.share.sampled.file.TDataOutputStream;

public class WaveAudioFileWriter
extends TAudioFileWriter {
    private static final AudioFileFormat.Type[] FILE_TYPES = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};
    private static final AudioFormat[] AUDIO_FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, false), new AudioFormat(WaveTool.GSM0610, -1.0f, -1, -1, -1, -1.0f, false), new AudioFormat(WaveTool.GSM0610, -1.0f, -1, -1, -1, -1.0f, true)};

    public WaveAudioFileWriter() {
        super(Arrays.asList(FILE_TYPES), Arrays.asList(AUDIO_FORMATS));
    }

    protected boolean isAudioFormatSupportedImpl(AudioFormat format, AudioFileFormat.Type fileType) {
        return WaveTool.getFormatCode(format) != 0;
    }

    protected AudioOutputStream getAudioOutputStream(AudioFormat audioFormat, long lLengthInBytes, AudioFileFormat.Type fileType, TDataOutputStream dataOutputStream) throws IOException {
        return new WaveAudioOutputStream(audioFormat, lLengthInBytes, dataOutputStream);
    }
}

