/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.sampled.mixer.esd.EsdSourceDataLine;
import org.tritonus.sampled.mixer.esd.EsdTargetDataLine;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TMixer;
import org.tritonus.share.sampled.mixer.TMixerInfo;
import org.tritonus.share.sampled.mixer.TSoftClip;

public class EsdMixer
extends TMixer {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static AudioFormat[] FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 2, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true)};
    private static Line.Info[] SOURCE_LINE_INFOS = new Line.Info[]{new DataLine.Info(SourceDataLine.class, FORMATS, -1, -1)};
    private static Line.Info[] TARGET_LINE_INFOS = new Line.Info[]{new DataLine.Info(TargetDataLine.class, FORMATS, -1, -1)};

    public EsdMixer() {
        super(new TMixerInfo("Esd Mixer", GlobalInfo.getVendor(), "Mixer for the Enlightened Sound Daemon (esd) running on the local machine", GlobalInfo.getVersion()), new Line.Info(Mixer.class), Arrays.asList(FORMATS), Arrays.asList(FORMATS), Arrays.asList(SOURCE_LINE_INFOS), Arrays.asList(TARGET_LINE_INFOS));
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.<init>: begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.<init>: end");
        }
    }

    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.open(): end");
        }
    }

    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.close(): end");
        }
    }

    public int getMaxLines(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getMaxLines(): begin");
        }
        int nMaxLines = 0;
        if (info instanceof DataLine.Info) {
            Class<?> lineClass = info.getLineClass();
            if (lineClass == SourceDataLine.class) {
                nMaxLines = 32;
            } else if (lineClass == TargetDataLine.class) {
                nMaxLines = 1;
            }
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getMaxLines(): end");
        }
        return nMaxLines;
    }

    protected SourceDataLine getSourceDataLine(AudioFormat format, int nBufferSize) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): format: " + format);
            TDebug.out("EsdMixer.getSourceDataLine(): buffer size: " + nBufferSize);
        }
        if (nBufferSize < 1) {
            nBufferSize = 32768;
        }
        EsdSourceDataLine sourceDataLine = new EsdSourceDataLine((TMixer)this, format, nBufferSize);
        sourceDataLine.start();
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): returning: " + sourceDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): end");
        }
        return sourceDataLine;
    }

    protected TargetDataLine getTargetDataLine(AudioFormat format, int nBufferSize) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): begin");
        }
        int nBufferSizeInBytes = nBufferSize * format.getFrameSize();
        EsdTargetDataLine targetDataLine = new EsdTargetDataLine((TMixer)this, format, nBufferSizeInBytes);
        targetDataLine.start();
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): returning: " + targetDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): end");
        }
        return targetDataLine;
    }

    protected Clip getClip(AudioFormat format) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getClip(): begin");
        }
        TSoftClip clip = new TSoftClip((Mixer)this, format);
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getClip(): end");
        }
        return clip;
    }
}

