/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingServices {
    public static final String SUBSCRIBER_QUEUE = "subscriber";
    public static final String ERROR_TOPIC = "error";
    public static final String MESSAGE_TOPIC = "message";
    private static Logger log = LoggerFactory.getLogger(MessagingServices.class);
    private static int refCount = 0;
    private static MessagingServices instance;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private Map<String, Destination> destinations;

    public static MessagingServices getInstance() throws JMSException {
        if (instance == null) {
            instance = new MessagingServices();
        }
        ++refCount;
        return instance;
    }

    private MessagingServices() throws JMSException {
        try {
            log.debug("Starting message queue services...");
            JsonSimpleConfig config = new JsonSimpleConfig();
            String brokerUrl = config.getString("tcp://localhost:61616", "messaging", "url");
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerUrl);
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer(null);
            this.producer.setDeliveryMode(2);
            this.destinations = new HashMap<String, Destination>();
        }
        catch (IOException ioe) {
            log.error("Failed to read configuration: {}", (Object)ioe.getMessage());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public void release() {
        if (instance != null && --refCount <= 0) {
            log.info("Closing message queue services...");
            if (this.producer != null) {
                try {
                    this.producer.close();
                }
                catch (JMSException jmse) {
                    log.warn("Failed to close producer: {}", (Object)jmse.getMessage());
                }
            }
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (JMSException jmse) {
                    log.warn("Failed to close session: {}", (Object)jmse.getMessage());
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (JMSException jmse) {
                    log.warn("Failed to close connection: {}", (Object)jmse.getMessage());
                }
            }
            refCount = 0;
            instance = null;
        }
    }

    public void publishMessage(String name, String msg) {
        try {
            this.sendMessage(this.getDestination(name, false), msg);
        }
        catch (JMSException jmse) {
            log.error("Failed to publish message", (Throwable)jmse);
        }
    }

    public void queueMessage(String name, String msg) {
        try {
            this.sendMessage(this.getDestination(name, true), msg);
        }
        catch (JMSException jmse) {
            log.error("Failed to queue message", (Throwable)jmse);
        }
    }

    public void sendMessage(Destination destination, String msg) throws JMSException {
        TextMessage message = this.session.createTextMessage(msg);
        this.producer.send(destination, (Message)message);
    }

    private Destination getDestination(String name, boolean queue) throws JMSException {
        Destination destination = this.destinations.get(name);
        if (destination == null) {
            destination = queue ? this.session.createQueue(name) : this.session.createTopic(name);
            this.destinations.put(name, destination);
        }
        return destination;
    }

    public void onEvent(Map<String, String> param) {
        JsonObject json = new JsonObject();
        String username = param.get("username");
        if (username == null) {
            username = "guest";
        }
        json.put("oid", param.get("oid"));
        json.put("eventType", param.get("eventType"));
        json.put("context", param.get("context"));
        json.put("user", username);
        this.queueMessage(SUBSCRIBER_QUEUE, json.toString());
    }
}

