/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.access;

import com.googlecode.fascinator.api.access.AccessControlSchema;
import com.googlecode.fascinator.common.JsonObject;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSchema
implements AccessControlSchema {
    private Logger log = LoggerFactory.getLogger(GenericSchema.class);
    private JsonObject response;
    private String recordId;
    private String securitySource;

    public final String describeMetadata() {
        String class_name = this.getClass().getCanonicalName();
        try {
            Class<?> ref_class = Class.forName(class_name);
            Field[] field_list = ref_class.getDeclaredFields();
            this.response = new JsonObject();
            this.response.put("recordId", "String");
            for (int i = 0; i < field_list.length; ++i) {
                this.response.put(field_list[i].getName(), field_list[i].getType().getSimpleName());
            }
            return this.response.toString();
        }
        catch (ClassNotFoundException ex) {
            this.log.error(ex.getMessage());
            return "Error retrieving user specification";
        }
    }

    public final String get(String property) {
        String class_name = this.getClass().getCanonicalName();
        try {
            Class<?> ref_class = Class.forName(class_name);
            Field[] field_list = ref_class.getDeclaredFields();
            for (int i = 0; i < field_list.length; ++i) {
                if (!property.equals(field_list[i].getName())) continue;
                try {
                    if (field_list[i].get(this) == null) {
                        return null;
                    }
                    return field_list[i].get(this).toString();
                }
                catch (IllegalArgumentException ex) {
                    this.log.error("User Object, Illegal argument : {}", (Throwable)ex);
                    return null;
                }
                catch (IllegalAccessException ex) {
                    this.log.error("User Object, Illegal access : {}", (Throwable)ex);
                    return null;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error(ex.getMessage());
            return null;
        }
        return null;
    }

    public final void set(String property, String value) {
        String class_name = this.getClass().getCanonicalName();
        try {
            Class<?> ref_class = Class.forName(class_name);
            Field[] field_list = ref_class.getDeclaredFields();
            for (int i = 0; i < field_list.length; ++i) {
                if (!property.equals(field_list[i].getName())) continue;
                try {
                    field_list[i].set(this, value);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    this.log.error("Security Object, Illegal argument : {}", (Throwable)ex);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    this.log.error("Security Object, Illegal access : {}", (Throwable)ex);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error(ex.getMessage());
            return;
        }
    }

    public void setRecordId(String newid) {
        this.recordId = newid;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setSource(String plugin) {
        this.securitySource = plugin;
    }

    public String getSource() {
        return this.securitySource;
    }
}

