/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.storage.impl;

import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.MimeTypeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPayload
implements Payload {
    private static Logger log = LoggerFactory.getLogger(GenericPayload.class);
    private PayloadType type;
    private boolean linked = false;
    private String id;
    private String label;
    private String contentType;
    private InputStream inputStream;
    private byte[] ramStore;
    private boolean metaChanged = false;

    public GenericPayload(String id) {
        this.setId(id);
    }

    public GenericPayload(String id, String label, String contentType) {
        this(id, label, contentType, null);
    }

    public GenericPayload(String id, String label, String contentType, PayloadType payloadType) {
        this.setId(id);
        this.setLabel(label);
        this.setContentType(contentType);
        this.setType(payloadType);
        this.metaChanged = false;
    }

    public GenericPayload(String id, File payloadFile) {
        this.setId(id);
        this.setLabel(payloadFile.getPath());
        this.setContentType(MimeTypeUtil.getMimeType(payloadFile));
        try {
            this.setInputStream(new FileInputStream(payloadFile));
        }
        catch (IOException e) {
            log.error("Error accessing input stream during payload creation", (Throwable)e);
        }
        this.metaChanged = false;
    }

    public GenericPayload(Payload payload) {
        if (payload != null) {
            this.setId(payload.getId());
            this.setLabel(payload.getLabel());
            this.setContentType(payload.getContentType());
            this.setType(payload.getType());
            try {
                this.setInputStream(payload.open());
            }
            catch (StorageException e) {
                log.error("Error accessing input stream during payload creation", (Throwable)e);
            }
        }
        this.metaChanged = false;
    }

    public boolean hasMetaChanged() {
        return this.metaChanged;
    }

    public void setMetaChanged(boolean metaChanged) {
        this.metaChanged = metaChanged;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        id = id.replace("\\", "/");
        this.metaChanged = this.metaChanged || this.id != id;
        this.id = id;
    }

    public PayloadType getType() {
        return this.type;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void setLinked(boolean newLinked) {
        this.metaChanged = this.metaChanged || this.linked != newLinked;
        this.linked = newLinked;
    }

    public void setType(PayloadType type) {
        this.metaChanged = this.metaChanged || this.type != type;
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.metaChanged = this.metaChanged || this.label != label;
        this.label = label;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.metaChanged = this.metaChanged || this.contentType != contentType;
        this.contentType = contentType;
    }

    public InputStream open() throws StorageException {
        this.inputStream = new ByteArrayInputStream(this.ramStore);
        return this.inputStream;
    }

    public void close() throws StorageException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                log.warn("Error closing input stream", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
            this.ramStore = out.toByteArray();
            this.setContentType(MimeTypeUtil.getMimeType(this.ramStore, this.getId()));
        }
        catch (Exception e) {
            log.error("Failed to copy content to memory", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                log.error("Failed to close content input stream", (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return this.getId();
    }

    public Long lastModified() {
        return null;
    }

    public Long size() {
        return null;
    }
}

