/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.ManifestNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Manifest
extends JsonSimple {
    public Manifest(JsonObject newJsonObject) {
        super(newJsonObject);
    }

    public Manifest(InputStream jsonIn) throws IOException {
        super(jsonIn);
    }

    public Manifest(String jsonString) throws IOException {
        super(jsonString);
    }

    public int size() {
        return this.count(this.getTopNodes());
    }

    private int count(List<ManifestNode> list) {
        if (list == null) {
            return 0;
        }
        int thisList = list.size();
        for (ManifestNode entry : list) {
            thisList += this.count(entry.getChildren());
        }
        return thisList;
    }

    public ManifestNode getNode(String key) {
        return this.findNode(key, this.getTopNodes());
    }

    private ManifestNode findNode(String key, List<ManifestNode> list) {
        if (list == null) {
            return null;
        }
        for (ManifestNode node : list) {
            if (node.getKey().equals(key)) {
                return node;
            }
            ManifestNode descendent = this.findNode(key, node.getChildren());
            if (descendent == null) continue;
            return descendent;
        }
        return null;
    }

    public boolean addTopNode(String id, String title) {
        if (id == null || title == null) {
            return false;
        }
        String key = "node-" + id;
        ManifestNode node = new ManifestNode();
        node.setId(id);
        node.setTitle(title);
        node.setKey(key);
        node.setParentKey(null);
        JsonObject object = this.writeObject("manifest");
        object.put(key, node.getJsonObject());
        return true;
    }

    public List<ManifestNode> getTopNodes() {
        ArrayList<ManifestNode> nodes = new ArrayList<ManifestNode>();
        Map<String, JsonSimple> manifest = this.getJsonSimpleMap("manifest");
        if (manifest == null) {
            return nodes;
        }
        for (String key : manifest.keySet()) {
            ManifestNode manNode = new ManifestNode(manifest.get(key).getJsonObject());
            manNode.setParentKey(null);
            manNode.setKey(key);
            nodes.add(manNode);
        }
        return nodes;
    }

    private JsonObject getWritableNode(String key) {
        if (key == null) {
            return this.getObject("manifest");
        }
        ManifestNode node = this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.writeObject("children");
    }

    private JsonObject getWritableParent(String id) {
        ManifestNode node = this.getNode(id);
        if (node == null) {
            return null;
        }
        String pId = node.getParentKey();
        JsonObject target = this.getWritableNode(pId);
        if (target == null || !target.containsKey(id)) {
            return null;
        }
        return target;
    }

    public boolean move(String id, String destination) {
        JsonObject toRemove = this.getWritableParent(id);
        JsonObject toMove = this.getWritableNode(destination);
        if (toRemove == null || toMove == null) {
            return false;
        }
        toMove.put(id, toRemove.get(id));
        toRemove.remove(id);
        this.getNode(id).setParentKey(destination);
        return true;
    }

    public boolean moveAfter(String id, String destination) {
        JsonObject toRemove = this.getWritableParent(id);
        JsonObject toMove = this.getWritableParent(destination);
        if (toRemove == null || toMove == null) {
            return false;
        }
        Object movedNode = toRemove.get(id);
        toRemove.remove(id);
        JsonObject newMap = new JsonObject();
        for (Object objKey : toMove.keySet()) {
            String key = (String)objKey;
            if (key.equals(destination)) {
                newMap.put(objKey, toMove.get(objKey));
                newMap.put(id, movedNode);
                continue;
            }
            newMap.put(objKey, toMove.get(objKey));
        }
        toMove.clear();
        toMove.putAll(newMap);
        String pId = this.getNode(destination).getParentKey();
        this.getNode(id).setParentKey(pId);
        return true;
    }

    public boolean moveBefore(String id, String destination) {
        JsonObject toRemove = this.getWritableParent(id);
        JsonObject toMove = this.getWritableParent(destination);
        if (toRemove == null || toMove == null) {
            return false;
        }
        Object movedNode = toRemove.get(id);
        toRemove.remove(id);
        JsonObject newMap = new JsonObject();
        for (Object objKey : toMove.keySet()) {
            String key = (String)objKey;
            if (key.equals(destination)) {
                newMap.put(id, movedNode);
                newMap.put(objKey, toMove.get(objKey));
                continue;
            }
            newMap.put(objKey, toMove.get(objKey));
        }
        toMove.clear();
        toMove.putAll(newMap);
        String pId = this.getNode(destination).getParentKey();
        this.getNode(id).setParentKey(pId);
        return true;
    }

    public boolean delete(String id) {
        JsonObject toRemove = this.getWritableParent(id);
        if (toRemove == null) {
            return false;
        }
        toRemove.remove(id);
        return true;
    }

    public String getDescription() {
        return this.getString(null, "description");
    }

    public void setDescription(String description) {
        this.getJsonObject().put("description", description);
    }

    public String getTitle() {
        return this.getString(null, "title");
    }

    public void setTitle(String title) {
        this.getJsonObject().put("title", title);
    }

    public String getType() {
        return this.getString(null, "packageType");
    }

    public void setType(String type) {
        this.getJsonObject().put("packageType", type);
    }

    public String getViewId() {
        return this.getString(null, "viewId");
    }

    public void setViewId(String viewId) {
        this.getJsonObject().put("viewId", viewId);
    }
}

