/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.messaging;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.messaging.MessagingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingServices {
    public static final String SUBSCRIBER_QUEUE = "subscriber";
    public static final String ERROR_TOPIC = "error";
    public static final String MESSAGE_TOPIC = "message";
    private static Logger log = LoggerFactory.getLogger(MessagingServices.class);
    private static int refCount = 0;
    private static MessagingServices instance;
    private String localBroker = "tcp://localhost:61616";
    private Map<String, ActiveMQConnectionFactory> connectors;
    private Map<String, Connection> connections;
    private Map<String, Session> sessions;
    private Map<String, MessageProducer> producers;

    public static MessagingServices getInstance() throws MessagingException {
        if (instance == null) {
            instance = new MessagingServices();
        }
        ++refCount;
        return instance;
    }

    private MessagingServices() throws MessagingException {
        log.info("Starting message queue services...");
        JsonSimpleConfig config = null;
        try {
            config = new JsonSimpleConfig();
            this.localBroker = config.getString(this.localBroker, "messaging", "url");
        }
        catch (IOException ioe) {
            log.error("Failed to read configuration: {}", (Object)ioe.getMessage());
        }
        this.connectors = new HashMap<String, ActiveMQConnectionFactory>();
        this.connectors.put(this.localBroker, new ActiveMQConnectionFactory(this.localBroker));
        this.connections = new HashMap<String, Connection>();
        this.sessions = new HashMap<String, Session>();
        this.producers = new HashMap<String, MessageProducer>();
        this.newProducer();
    }

    private Connection newConnection() throws MessagingException {
        return this.newConnection(this.localBroker);
    }

    private Connection newConnection(String brokerUrl) throws MessagingException {
        if (!this.connectors.containsKey(brokerUrl)) {
            log.info("Opening new AMQ Connection Factory for broker: '{}'", (Object)brokerUrl);
            this.connectors.put(brokerUrl, new ActiveMQConnectionFactory(brokerUrl));
        }
        try {
            this.connections.put(brokerUrl, this.connectors.get(brokerUrl).createConnection());
        }
        catch (JMSException ex) {
            try {
                log.warn("Failed to create Connection! Try new connector.");
                this.connectors.put(brokerUrl, new ActiveMQConnectionFactory(brokerUrl));
                this.connections.put(brokerUrl, this.connectors.get(brokerUrl).createConnection());
            }
            catch (JMSException ex1) {
                log.error("Error creating connection: ", (Throwable)ex1);
                throw new MessagingException(ex1);
            }
        }
        try {
            this.connections.get(brokerUrl).start();
        }
        catch (JMSException ex) {
            log.error("Error starting the new connection: ", (Throwable)ex);
            throw new MessagingException(ex);
        }
        return this.connections.get(brokerUrl);
    }

    private Session newSession() throws MessagingException {
        return this.newSession(this.localBroker);
    }

    private Session newSession(String brokerUrl) throws MessagingException {
        if (!this.connections.containsKey(brokerUrl)) {
            log.info("Opening new AMQ Session for broker: '{}'", (Object)brokerUrl);
            this.newConnection(brokerUrl);
        }
        try {
            this.sessions.put(brokerUrl, this.connections.get(brokerUrl).createSession(false, 1));
        }
        catch (JMSException ex) {
            try {
                log.warn("Failed to create Session! Trying a new connection.");
                this.newConnection(brokerUrl);
                this.sessions.put(brokerUrl, this.connections.get(brokerUrl).createSession(false, 1));
            }
            catch (JMSException ex1) {
                log.error("Error establishing a new session: ", (Throwable)ex1);
                throw new MessagingException(ex1);
            }
        }
        return this.sessions.get(brokerUrl);
    }

    private MessageProducer newProducer() throws MessagingException {
        return this.newProducer(this.localBroker);
    }

    private MessageProducer newProducer(String brokerUrl) throws MessagingException {
        if (!this.sessions.containsKey(brokerUrl)) {
            log.info("Creating new AMQ Producer for broker: '{}'", (Object)brokerUrl);
            this.newSession(brokerUrl);
        }
        try {
            this.producers.put(brokerUrl, this.sessions.get(brokerUrl).createProducer(null));
            this.producers.get(brokerUrl).setDeliveryMode(2);
        }
        catch (JMSException ex) {
            log.error("Error starting a new producer: ", (Throwable)ex);
            throw new MessagingException(ex);
        }
        return this.producers.get(brokerUrl);
    }

    public void release() {
        if (instance != null && --refCount <= 0) {
            log.info("Closing message queue services...");
            if (this.producers != null && !this.producers.isEmpty()) {
                for (String key : this.producers.keySet()) {
                    log.info("Closing producer for broker '{}'", (Object)key);
                    try {
                        this.producers.get(key).close();
                    }
                    catch (JMSException jmse) {
                        log.warn("... failed: {}", (Throwable)jmse);
                    }
                }
            }
            if (this.sessions != null && !this.sessions.isEmpty()) {
                for (String key : this.sessions.keySet()) {
                    log.info("Closing session for broker '{}'", (Object)key);
                    try {
                        this.sessions.get(key).close();
                    }
                    catch (JMSException jmse) {
                        log.warn("... failed: {}", (Throwable)jmse);
                    }
                }
            }
            if (this.connections != null && !this.connections.isEmpty()) {
                for (String key : this.connections.keySet()) {
                    log.info("Closing connection for broker '{}'", (Object)key);
                    try {
                        this.connections.get(key).close();
                    }
                    catch (JMSException jmse) {
                        log.warn("... failed: {}", (Throwable)jmse);
                    }
                }
            }
            refCount = 0;
            instance = null;
        }
    }

    public void publishMessage(String name, String msg) throws MessagingException {
        this.publishMessage(this.localBroker, name, msg);
    }

    public void publishMessage(String brokerUrl, String name, String msg) throws MessagingException {
        Destination destination = this.getDestination(brokerUrl, name, false);
        TextMessage message = this.prepareMessage(brokerUrl, msg);
        this.sendMessage(brokerUrl, destination, message);
    }

    public void queueMessage(String name, String msg) throws MessagingException {
        this.queueMessage(this.localBroker, name, msg);
    }

    public void queueMessage(String brokerUrl, String name, String msg) throws MessagingException {
        Destination destination = this.getDestination(brokerUrl, name, true);
        TextMessage message = this.prepareMessage(brokerUrl, msg);
        this.sendMessage(brokerUrl, destination, message);
    }

    public void sendMessage(String brokerUrl, Destination destination, TextMessage msg) throws MessagingException {
        if (!this.producers.containsKey(brokerUrl)) {
            this.newProducer(brokerUrl);
        }
        try {
            this.producers.get(brokerUrl).send(destination, (Message)msg);
        }
        catch (JMSException ex) {
            try {
                log.warn("Failed to send message! Trying a new producer.");
                this.newProducer(brokerUrl);
                this.producers.get(brokerUrl).send(destination, (Message)msg);
            }
            catch (JMSException ex1) {
                log.error("Failed to send message:", (Throwable)ex1);
                throw new MessagingException(ex1);
            }
        }
    }

    private TextMessage prepareMessage(String brokerUrl, String msg) throws MessagingException {
        if (!this.sessions.containsKey(brokerUrl)) {
            this.newSession(brokerUrl);
        }
        try {
            return this.sessions.get(brokerUrl).createTextMessage(msg);
        }
        catch (JMSException ex) {
            try {
                log.warn("Failed to create message! Trying a new session.");
                this.newSession(brokerUrl);
                return this.sessions.get(brokerUrl).createTextMessage(msg);
            }
            catch (JMSException ex1) {
                log.error("Failed to create message:", (Throwable)ex1);
                throw new MessagingException(ex1);
            }
        }
    }

    private Destination getDestination(String brokerUrl, String name, boolean queue) throws MessagingException {
        if (!this.sessions.containsKey(brokerUrl)) {
            this.newSession(brokerUrl);
        }
        try {
            return this.createDestination(this.sessions.get(brokerUrl), name, queue);
        }
        catch (JMSException ex) {
            try {
                log.warn("Failed to create Destination! Trying a new session.");
                this.newSession(brokerUrl);
                return this.createDestination(this.sessions.get(brokerUrl), name, queue);
            }
            catch (JMSException ex1) {
                log.error("Failed to create Destination:", (Throwable)ex1);
                throw new MessagingException(ex1);
            }
        }
    }

    private Destination createDestination(Session session, String name, boolean queue) throws JMSException {
        if (queue) {
            return session.createQueue(name);
        }
        return session.createTopic(name);
    }

    public void onEvent(Map<String, String> param) throws MessagingException {
        JsonObject json = new JsonObject();
        String username = param.get("username");
        if (username == null) {
            username = "guest";
        }
        json.put("oid", param.get("oid"));
        json.put("eventType", param.get("eventType"));
        json.put("context", param.get("context"));
        json.put("user", username);
        this.queueMessage(SUBSCRIBER_QUEUE, json.toString());
    }
}

