/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.solr;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;

public class SolrDoc
extends JsonSimple {
    public SolrDoc(JsonObject newJsonObject) {
        super(newJsonObject);
    }

    public String get(String field) {
        Object object = this.getPath(field);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            List<String> array = JsonSimple.getStringList((JSONArray)object);
            if (array.size() == 1) {
                return array.get(0);
            }
            return "[\"" + StringUtils.join(array, (String)"\", \"") + "\"]";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Double) {
            return Double.toString((Double)object);
        }
        return null;
    }

    public String getFirst(String field) {
        List<String> array;
        String first;
        Object object = this.getPath(field);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray && (first = (array = JsonSimple.getStringList((JSONArray)object)).get(0)) instanceof String) {
            return first;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public List<String> getList(String field) {
        Object object = this.getPath(field);
        if (object == null) {
            return new LinkedList<String>();
        }
        if (object instanceof JSONArray) {
            return JsonSimple.getStringList((JSONArray)object);
        }
        if (object instanceof String) {
            LinkedList<String> response = new LinkedList<String>();
            response.add((String)object);
            return response;
        }
        return null;
    }
}

