/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.solr;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;

public class SolrResult
extends JsonSimple {
    private List<SolrDoc> results;
    private Map<String, SolrFacet> facets;

    public SolrResult(InputStream jsonIn) throws IOException {
        super(jsonIn);
    }

    public SolrResult(String jsonString) throws IOException {
        super(jsonString);
    }

    public Map<String, SolrFacet> getFacets() {
        if (this.facets == null) {
            this.facets = new LinkedHashMap<String, SolrFacet>();
            JsonObject object = this.getObject("facet_counts", "facet_fields");
            if (object == null) {
                return null;
            }
            for (Object key : object.keySet()) {
                Object value = object.get(key);
                if (!(value instanceof JSONArray)) continue;
                this.facets.put((String)key, new SolrFacet((String)key, (JSONArray)value));
            }
        }
        return this.facets;
    }

    public List<String> getFieldList(String field) {
        ArrayList<String> response = new ArrayList<String>();
        for (SolrDoc doc : this.getResults()) {
            response.add(doc.get(field));
        }
        return response;
    }

    public Integer getNumFound() {
        return this.getInteger(null, "response", "numFound");
    }

    public Integer getQueryTime() {
        return this.getInteger(null, "responseHeader", "QTime");
    }

    public List<SolrDoc> getResults() {
        if (this.results == null) {
            this.results = new LinkedList<SolrDoc>();
            JSONArray array = this.getArray("response", "docs");
            if (array == null) {
                return null;
            }
            for (Object object : array) {
                if (!(object instanceof JsonObject)) continue;
                this.results.add(new SolrDoc((JsonObject)object));
            }
        }
        return this.results;
    }

    public Integer getRows() {
        List<SolrDoc> rows = this.getResults();
        if (rows != null) {
            return rows.size();
        }
        return null;
    }

    public Integer getStartRow() {
        return this.getInteger(null, "response", "start");
    }

    public Integer getStatus() {
        return this.getInteger(null, "responseHeader", "status");
    }
}

