/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetAddressUtil {
    private static final Logger log = LoggerFactory.getLogger(InetAddressUtil.class);

    private InetAddressUtil() {
    }

    public static boolean contains(InetAddress network, InetAddress netmask, InetAddress ip) {
        if (log.isDebugEnabled()) {
            log.debug("=======================================");
            log.debug("Checking IP address: " + ip + " in " + network + " / " + netmask);
        }
        byte[] networkBytes = network.getAddress();
        byte[] netmaskBytes = netmask.getAddress();
        byte[] ipBytes = ip.getAddress();
        if (networkBytes.length != netmaskBytes.length || netmaskBytes.length != ipBytes.length) {
            if (log.isDebugEnabled()) {
                log.debug("Network address " + network + ", subnet mask " + netmask + " and/or host address " + ip + " have different sizes! (return false ...)");
                log.debug("=======================================");
            }
            return false;
        }
        for (int i = 0; i < netmaskBytes.length; ++i) {
            int mask = netmaskBytes[i] & 0xFF;
            if ((networkBytes[i] & mask) == (ipBytes[i] & mask)) continue;
            if (log.isDebugEnabled()) {
                log.debug(ip + " is not in " + network + " / " + netmask);
                log.debug("=======================================");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug(ip + " is in " + network + " / " + netmask);
            log.debug("=======================================");
        }
        return true;
    }

    @Deprecated
    public static int getClassPart(InetAddress ip, int partNumber) {
        String[] parts = ip.getHostAddress().split("\\.");
        String part = parts[partNumber];
        return new Integer(part);
    }

    @Deprecated
    public static int checkNetmask(InetAddress netmask) {
        int i;
        String[] parts = netmask.getHostAddress().split("\\.");
        Integer[] numbers = new Integer[4];
        for (i = 0; i < 4; ++i) {
            numbers[i] = new Integer(parts[i]);
        }
        for (i = 0; i < 4; ++i) {
            log.debug(".checkNetmask(): Check part: " + numbers[i]);
            if (0 <= numbers[i] && numbers[i] <= 255) {
                if (numbers[i] == 255) continue;
                for (int k = i + 1; k < 4; ++k) {
                    if (numbers[k] == 0) continue;
                    log.error(".checkNetmask(): Illegal Netmask: " + netmask);
                    return -1;
                }
                return i;
            }
            log.error(".checkNetmask(): Illegal Netmask: " + netmask);
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug("All parts equal 255: " + netmask);
        }
        return 3;
    }

    @Deprecated
    public static InetAddress getAddress(String string) throws UnknownHostException {
        String[] strings = string.split("\\.");
        byte[] numbers = new byte[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            int number = Integer.parseInt(strings[i]);
            if (number > 127) {
                number -= 256;
            }
            numbers[i] = (byte)number;
        }
        InetAddress address = InetAddress.getByAddress(numbers);
        return address;
    }
}

