/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.sax;

import com.googlecode.fascinator.common.sax.SafeSAXParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SafeSAXReader {
    private String feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private SAXReader reader = new SAXReader((XMLReader)((Object)new SafeSAXParser()));

    public SafeSAXReader() {
        this.reader.setValidation(false);
        try {
            this.reader.setFeature(this.feature, false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Document loadDocument(String inDoc) throws DocumentException {
        return this.reader.read(inDoc);
    }

    public Document loadDocumentFromStream(InputStream inStream) throws DocumentException {
        return this.reader.read(inStream);
    }

    public String docToString(Node outDoc) throws IOException {
        StringWriter osw = new StringWriter();
        OutputFormat opf = new OutputFormat("", false, "UTF-8");
        opf.setSuppressDeclaration(true);
        opf.setExpandEmptyElements(true);
        XMLWriter writer = new XMLWriter((Writer)osw, opf);
        writer.setEscapeText(false);
        writer.write(outDoc);
        writer.close();
        return ((Object)osw).toString();
    }

    public void docToStream(Node outDoc, OutputStream outStream) throws IOException {
        OutputFormat opf = new OutputFormat("", false, "UTF-8");
        opf.setSuppressDeclaration(true);
        opf.setExpandEmptyElements(true);
        XMLWriter writer = new XMLWriter(outStream, opf);
        writer.setEscapeText(false);
        writer.write(outDoc);
        writer.close();
    }
}

