/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthentication {
    private Logger log = LoggerFactory.getLogger(LdapAuthentication.class);
    private Hashtable<String, String> env;
    private String baseDn;
    private String idAttr;

    public LdapAuthentication(String baseUrl, String baseDn) {
        this(baseUrl, baseDn, "uid");
    }

    public LdapAuthentication(String baseUrl, String baseDn, String idAttr) {
        this.baseDn = baseDn;
        this.idAttr = idAttr;
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", baseUrl);
        this.env.put("java.naming.security.authentication", "simple");
    }

    public boolean authenticate(String username, String password) {
        try {
            String principal = String.format("%s=%s,%s", this.idAttr, username, this.baseDn);
            this.env.put("java.naming.security.principal", principal);
            this.env.put("java.naming.security.credentials", password);
            InitialDirContext ctx = new InitialDirContext(this.env);
            ctx.lookup(principal);
            ctx.close();
            return true;
        }
        catch (NamingException ne) {
            this.log.warn("Failed LDAP lookup", (Throwable)ne);
            return false;
        }
    }
}

