/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.harvester.impl;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.harvester.Harvester;
import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public abstract class GenericHarvester
implements Harvester {
    private String id;
    private String name;
    private JsonSimpleConfig config;
    private Storage storage;

    public GenericHarvester(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public Set<String> getObjectId(File uploadedFile) throws HarvesterException {
        throw new HarvesterException("This plugin does not support uploaded files");
    }

    public Set<String> getDeletedObjectIdList() throws HarvesterException {
        return Collections.emptySet();
    }

    public boolean hasMoreDeletedObjects() {
        return false;
    }

    public Storage getStorage() throws HarvesterException {
        if (this.storage == null) {
            throw new HarvesterException("Storage plugin has not been set!");
        }
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.init();
        }
        catch (IOException ioe) {
            throw new HarvesterException((Throwable)ioe);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.init();
        }
        catch (IOException ioe) {
            throw new HarvesterException((Throwable)ioe);
        }
    }

    public abstract void init() throws HarvesterException;

    public void shutdown() throws PluginException {
    }

    public JsonSimpleConfig getJsonConfig() throws HarvesterException {
        if (this.config == null) {
            try {
                this.config = new JsonSimpleConfig();
            }
            catch (IOException ioe) {
                throw new HarvesterException((Throwable)ioe);
            }
        }
        return this.config;
    }
}

