/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyFileLock {
    private String file_name;
    private FileOutputStream file;
    private FileChannel fileChannel;
    private FileLock lock;
    private Logger log = LoggerFactory.getLogger(DummyFileLock.class);

    public DummyFileLock(String new_file) throws IOException {
        this.file_name = new_file;
    }

    public void getLock() throws IOException {
        this.file = new FileOutputStream(this.file_name);
        this.fileChannel = this.file.getChannel();
        int lockTimeout = 0;
        int lockSleepTime = 500;
        try {
            this.lock = this.fileChannel.lock();
        }
        catch (OverlappingFileLockException e) {
            try {
                if ((lockTimeout += lockSleepTime) > 60000) {
                    this.log.error("File Lock Timeout error : Waited more then 60s for access to : " + this.file_name);
                    this.fileChannel.close();
                    this.file.close();
                } else {
                    Thread.sleep(lockSleepTime);
                    this.getLock();
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted waiting for lock! Terminating.");
            }
        }
    }

    public void release() throws IOException {
        if (this.lock.isValid()) {
            this.lock.release();
        }
        if (this.fileChannel.isOpen()) {
            this.fileChannel.close();
            this.file.close();
        }
    }
}

