/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.lang.text.StrSubstitutor;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigHelper {
    private Logger log = LoggerFactory.getLogger(JsonConfigHelper.class);
    private Map<String, Object> rootNode;
    private JXPathContext jxPath;

    public JsonConfigHelper() {
        this.rootNode = new LinkedHashMap<String, Object>();
    }

    public JsonConfigHelper(Map<String, Object> rootNode) {
        this.rootNode = rootNode;
    }

    public JsonConfigHelper(String jsonContent) throws IOException {
        this.rootNode = (Map)new ObjectMapper().readValue(jsonContent, Map.class);
    }

    public JsonConfigHelper(File jsonFile) throws IOException {
        this.rootNode = (Map)new ObjectMapper().readValue(jsonFile, Map.class);
    }

    public JsonConfigHelper(InputStream jsonIn) throws IOException {
        this.rootNode = (Map)new ObjectMapper().readValue(jsonIn, Map.class);
    }

    public JsonConfigHelper(Reader jsonReader) throws IOException {
        this.rootNode = (Map)new ObjectMapper().readValue(jsonReader, Map.class);
    }

    private JXPathContext getJXPath() {
        if (this.jxPath == null) {
            this.jxPath = JXPathContext.newContext(this.rootNode);
            this.jxPath.setFactory((AbstractFactory)new JsonMapFactory());
            this.jxPath.setLenient(true);
        }
        return this.jxPath;
    }

    public String get(String path) {
        return this.get(path, null);
    }

    public String get(String path, String defaultValue) {
        Object valueNode = null;
        try {
            valueNode = this.getJXPath().getValue(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        String value = valueNode == null ? defaultValue : valueNode.toString();
        return StrSubstitutor.replaceSystemProperties((Object)value);
    }

    public String getPlainText(String path, String defaultValue) {
        Object valueNode = null;
        try {
            valueNode = this.getJXPath().getValue(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        String value = valueNode == null ? defaultValue : valueNode.toString();
        return value;
    }

    public List<Object> getList(String path) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        Iterator valueIterator = this.getJXPath().iterate(path);
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            valueList.add(value instanceof String ? StrSubstitutor.replaceSystemProperties(value) : value);
        }
        return valueList;
    }

    public Map<String, Object> getMap(String path) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        Object valueNode = this.getJXPath().getValue(path);
        if (valueNode instanceof Map) {
            Map map = (Map)valueNode;
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value instanceof String) {
                    valueMap.put(key, StrSubstitutor.replaceSystemProperties(value));
                    continue;
                }
                valueMap.put(key, value);
            }
        }
        return valueMap;
    }

    public List<JsonConfigHelper> getJsonList(String path) {
        List<Object> list = this.getList(path);
        ArrayList<JsonConfigHelper> newList = new ArrayList<JsonConfigHelper>();
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            newList.add(new JsonConfigHelper((Map)obj));
        }
        return newList;
    }

    public Map<String, JsonConfigHelper> getJsonMap(String path) {
        Object valueNode;
        LinkedHashMap<String, JsonConfigHelper> jsonMap = new LinkedHashMap<String, JsonConfigHelper>();
        try {
            valueNode = this.getJXPath().getValue(path);
        }
        catch (Exception e) {
            return null;
        }
        if (valueNode instanceof Map) {
            Map map = (Map)valueNode;
            for (String key : map.keySet()) {
                jsonMap.put(key, new JsonConfigHelper((Map)map.get(key)));
            }
        }
        return jsonMap;
    }

    public void setMap(String path, Map<String, Object> map) {
        try {
            this.getJXPath().setValue(path, map);
        }
        catch (Exception e) {
            this.getJXPath().createPathAndSetValue(path, map);
        }
    }

    public void setMultiMap(String path, Map<String, Object> json) {
        for (String key : json.keySet()) {
            if (json.get(key) instanceof Map) {
                this.setMultiMap(path + "/" + key, (Map)json.get(key));
                continue;
            }
            this.getJXPath().createPathAndSetValue(path + "/" + key, json.get(key));
        }
    }

    public void setJsonMap(String path, Map<String, JsonConfigHelper> map) {
        for (String key : map.keySet()) {
            JsonConfigHelper json = map.get(key);
            try {
                this.getJXPath().setValue(path + "/" + key, json.getMap("/"));
            }
            catch (Exception e) {
                this.getJXPath().createPathAndSetValue(path + "/" + key, json.getMap("/"));
            }
        }
    }

    public void setJsonList(String path, List<JsonConfigHelper> jsonList) {
        Object valueNode = this.getJXPath().getValue(path);
        ArrayList<Map<String, Object>> valueList = new ArrayList<Map<String, Object>>();
        if (valueNode == null) {
            this.getJXPath().createPathAndSetValue(path, valueList);
        }
        for (JsonConfigHelper json : jsonList) {
            valueList.add(json.getMap("/"));
        }
    }

    public Map<String, Object> getMapWithChild(String path) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        Object valueNode = this.getJXPath().getValue(path);
        if (valueNode instanceof Map) {
            Map map = (Map)valueNode;
            for (String key : map.keySet()) {
                valueMap.put(key, map.get(key));
            }
        }
        return valueMap;
    }

    public void removePath(String path) {
        if (this.get(path) != null) {
            this.getJXPath().removePath(path);
        }
    }

    public void set(String path, String value) {
        try {
            this.getJXPath().setValue(path, (Object)value);
        }
        catch (Exception e) {
            this.getJXPath().createPathAndSetValue(path, (Object)value);
        }
    }

    public void move(String source, String dest) {
        Object copyValue = this.getJXPath().getValue(source);
        this.getJXPath().removePath(source);
        try {
            this.getJXPath().setValue(dest, copyValue);
        }
        catch (Exception e) {
            this.getJXPath().createPathAndSetValue(dest, copyValue);
        }
    }

    public void moveBefore(String path, String refPath) {
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        Object node = this.getJXPath().getValue(path);
        Object refNode = this.getJXPath().getValue(refPath);
        Map<String, Object> refParent = this.getMap(refPath + "/..");
        for (String key : refParent.keySet()) {
            Object value = refParent.get(key);
            if (value.equals(refNode)) {
                Map<String, Object> parent = this.getMap(path + "/..");
                for (String nodeKey : parent.keySet()) {
                    if (!parent.get(nodeKey).equals(node)) continue;
                    newMap.put(nodeKey, node);
                    this.getJXPath().removePath(path);
                    break;
                }
            }
            if (value.equals(node)) continue;
            newMap.put(key, value);
        }
        this.setMap(refPath.substring(0, refPath.lastIndexOf(47)), newMap);
    }

    public void moveAfter(String path, String refPath) {
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        Object node = this.getJXPath().getValue(path);
        Object refNode = this.getJXPath().getValue(refPath);
        Map<String, Object> refParent = this.getMap(refPath + "/..");
        block0: for (String key : refParent.keySet()) {
            Object value = refParent.get(key);
            if (!value.equals(node)) {
                newMap.put(key, value);
            }
            if (!value.equals(refNode)) continue;
            Map<String, Object> parent = this.getMap(path + "/..");
            for (String nodeKey : parent.keySet()) {
                if (!parent.get(nodeKey).equals(node)) continue;
                newMap.put(nodeKey, node);
                this.getJXPath().removePath(path);
                continue block0;
            }
        }
        this.setMap(refPath.substring(0, refPath.lastIndexOf(47)), newMap);
    }

    public void store(Writer writer) throws IOException {
        this.store(writer, false);
    }

    public void store(Writer writer, boolean pretty) throws IOException {
        JsonGenerator generator = new JsonFactory().createJsonGenerator(writer);
        if (pretty) {
            generator.useDefaultPrettyPrinter();
        }
        new ObjectMapper().writeValue(generator, this.rootNode);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean pretty) {
        String json = "{}";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.store(new OutputStreamWriter((OutputStream)out, "UTF-8"), pretty);
            json = out.toString("UTF-8");
        }
        catch (IOException e) {
            // empty catch block
        }
        return json;
    }

    private class JsonMapFactory
    extends AbstractFactory {
        private JsonMapFactory() {
        }

        public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
            if (parent instanceof Map) {
                ((Map)parent).put(name, new LinkedHashMap());
                return true;
            }
            return false;
        }
    }
}

