/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSimpleConfig
extends JsonSimple {
    private static Logger log = LoggerFactory.getLogger(JsonSimpleConfig.class);
    private static final String CONFIG_DIR = FascinatorHome.getPath();
    private static final String SYSTEM_CONFIG_FILE = "system-config.json";
    private JsonSimple systemConfig = new JsonSimple(JsonSimpleConfig.getSystemFile());

    public JsonSimpleConfig() throws IOException {
        super(JsonSimpleConfig.getSystemFile());
    }

    public JsonSimpleConfig(File jsonFile) throws IOException {
        super(jsonFile);
    }

    public JsonSimpleConfig(InputStream jsonIn) throws IOException {
        super(jsonIn);
    }

    public JsonSimpleConfig(String jsonString) throws IOException {
        super(jsonString);
    }

    public static File backupSystemFile() throws IOException {
        File configFile = new File(CONFIG_DIR, SYSTEM_CONFIG_FILE);
        File backupFile = new File(CONFIG_DIR, "system-config.json.old");
        if (!configFile.exists()) {
            throw new IOException("System file does not exist! '" + configFile.getAbsolutePath() + "'");
        }
        if (backupFile.exists()) {
            backupFile.delete();
        }
        FileOutputStream out = new FileOutputStream(backupFile);
        FileInputStream in = new FileInputStream(configFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
        log.info("Configuration copied to '{}'", (Object)backupFile);
        return backupFile;
    }

    public static File getSystemFile() throws IOException {
        File configFile = new File(CONFIG_DIR, SYSTEM_CONFIG_FILE);
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(configFile);
            IOUtils.copy((InputStream)JsonSimpleConfig.class.getResourceAsStream("/system-config.json"), (OutputStream)out);
            ((OutputStream)out).close();
            log.info("Default configuration copied to '{}'", (Object)configFile);
        }
        return configFile;
    }

    public boolean isConfigured() {
        return this.getBoolean(false, "configured");
    }

    public boolean isOutdated() {
        boolean outdated = false;
        String systemVersion = this.getString(null, "version");
        if (systemVersion == null) {
            return true;
        }
        try {
            JsonSimple compiledConfig = new JsonSimple(this.getClass().getResourceAsStream("/system-config.json"));
            String compiledVersion = compiledConfig.getString(null, "version");
            boolean bl = outdated = !systemVersion.equals(compiledVersion);
            if (compiledVersion == null) {
                return false;
            }
            if (outdated) {
                log.debug("Configuration versions do not match! '{}' != '{}'", (Object)systemVersion, (Object)compiledVersion);
            }
        }
        catch (IOException ioe) {
            log.error("Failed to parse compiled configuration!", (Throwable)ioe);
        }
        return outdated;
    }

    @Override
    public JSONArray getArray(Object ... path) {
        JSONArray array = super.getArray(path);
        if (array == null && this.systemConfig != null) {
            return this.systemConfig.getArray(path);
        }
        return array;
    }

    @Override
    public JsonObject getObject(Object ... path) {
        JsonObject object = super.getObject(path);
        if (object == null && this.systemConfig != null) {
            return this.systemConfig.getObject(path);
        }
        return object;
    }

    @Override
    public Object getPath(Object ... path) {
        Object object = super.getPath(path);
        if (object == null && this.systemConfig != null) {
            return this.systemConfig.getPath(path);
        }
        return object;
    }

    @Override
    public Boolean getBoolean(Boolean defaultValue, Object ... path) {
        Boolean bool = super.getBoolean(null, path);
        if (bool == null) {
            if (this.systemConfig != null) {
                return this.systemConfig.getBoolean(defaultValue, path);
            }
            return defaultValue;
        }
        return bool;
    }

    @Override
    public Integer getInteger(Integer defaultValue, Object ... path) {
        Integer integer = super.getInteger(null, path);
        if (integer == null) {
            if (this.systemConfig != null) {
                return this.systemConfig.getInteger(defaultValue, path);
            }
            return defaultValue;
        }
        return integer;
    }

    @Override
    public String getString(String defaultValue, Object ... path) {
        String string = super.getString(null, path);
        if (string == null) {
            if (this.systemConfig != null) {
                return this.systemConfig.getString(defaultValue, path);
            }
            return defaultValue;
        }
        return string;
    }

    @Override
    public List<String> getStringList(Object ... path) {
        List<String> list = super.getStringList(path);
        if (list == null && this.systemConfig != null) {
            return this.systemConfig.getStringList(path);
        }
        return list;
    }

    @Override
    public List<JsonSimple> getJsonSimpleList(Object ... path) {
        List<JsonSimple> list = super.getJsonSimpleList(path);
        if (list == null && this.systemConfig != null) {
            return this.systemConfig.getJsonSimpleList(path);
        }
        return list;
    }

    @Override
    public Map<String, JsonSimple> getJsonSimpleMap(Object ... path) {
        Map<String, JsonSimple> map = super.getJsonSimpleMap(path);
        if (map == null && this.systemConfig != null) {
            return this.systemConfig.getJsonSimpleMap(path);
        }
        return map;
    }

    @Override
    public List<Object> search(String node) {
        List<Object> results = super.search(node);
        if ((results == null || results.isEmpty()) && this.systemConfig != null) {
            return this.systemConfig.search(node);
        }
        return results;
    }

    public JsonObject writableSystemConfig() {
        return this.systemConfig.getJsonObject();
    }

    public void storeSystemConfig() throws IOException {
        FileWriter writer = new FileWriter(JsonSimpleConfig.getSystemFile());
        writer.write(this.systemConfig.toString(true));
        writer.close();
    }
}

