/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpClient {
    private Logger log = LoggerFactory.getLogger(BasicHttpClient.class);
    private String baseUrl;
    private UsernamePasswordCredentials credentials;

    public BasicHttpClient(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.baseUrl = baseUrl;
    }

    public void authenticate(String username, String password) {
        this.credentials = new UsernamePasswordCredentials(username, password);
    }

    public HttpClient getHttpClient(boolean auth) {
        HttpClient client = new HttpClient();
        try {
            URL url = new URL(this.baseUrl);
            Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
            if (!proxy.type().equals((Object)Proxy.Type.DIRECT)) {
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                String proxyHost = address.getHostName();
                int proxyPort = address.getPort();
                client.getHostConfiguration().setProxy(proxyHost, proxyPort);
                this.log.trace("Using proxy {}:{}", (Object)proxyHost, (Object)proxyPort);
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to get proxy settings: " + e.getMessage());
        }
        if (auth && this.credentials != null) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)this.credentials);
            this.log.trace("Credentials: username={}", (Object)this.credentials.getUserName());
        }
        return client;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public int executeMethod(HttpMethodBase method) throws IOException {
        boolean auth = !(method instanceof GetMethod);
        return this.executeMethod(method, auth);
    }

    public int executeMethod(HttpMethodBase method, boolean auth) throws IOException {
        this.log.trace("{} {}", (Object)method.getName(), (Object)method.getURI());
        int status = this.getHttpClient(auth).executeMethod((HttpMethod)method);
        this.log.trace("{} {}", (Object)status, (Object)HttpStatus.getStatusText((int)status));
        return status;
    }
}

