/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FascinatorHome {
    public static Logger log = LoggerFactory.getLogger(FascinatorHome.class);
    public static final String SYSTEM_KEY = "fascinator.home";
    public static final String DEFAULT_PATH = StrSubstitutor.replaceSystemProperties((Object)FilenameUtils.separatorsToSystem((String)"${user.home}/.fascinator"));

    public static String getPath() {
        String home = System.getProperty(SYSTEM_KEY, FascinatorHome.getenv("FASCINATOR_HOME", DEFAULT_PATH));
        return FilenameUtils.separatorsToSystem((String)home);
    }

    public static String getPath(String subDir) {
        return FascinatorHome.getPath() + File.separator + FilenameUtils.separatorsToSystem((String)subDir);
    }

    public static File getPathFile() {
        return new File(FascinatorHome.getPath());
    }

    public static File getPathFile(String subDir) {
        return new File(FascinatorHome.getPath(subDir));
    }

    private static String getenv(String name, String def) {
        String value = System.getenv(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    static {
        String home = FascinatorHome.getPath();
        System.setProperty(SYSTEM_KEY, home);
        log.info("Set Fascinator home to '{}'", (Object)home);
    }
}

