/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifier;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicMimeTypeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicMimeTypeIdentifierWrapper
implements MimeTypeIdentifier {
    private Logger log = LoggerFactory.getLogger(MagicMimeTypeIdentifierWrapper.class);
    private JsonSimple mimeTypes;
    private MagicMimeTypeIdentifier identifier;

    public MagicMimeTypeIdentifierWrapper() {
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            this.mimeTypes = new JsonSimple(config.getObject("mime-types"));
            this.identifier = new MagicMimeTypeIdentifier();
        }
        catch (IOException e) {
            this.log.warn("Failed to load custom MIME types");
        }
    }

    public int getMinArrayLength() {
        return this.identifier.getMinArrayLength();
    }

    public String identify(byte[] firstBytes, String fileName, URI uri) {
        String ext = FilenameUtils.getExtension((String)fileName);
        String mimeType = this.mimeTypes.getString(null, ext);
        if (mimeType != null) {
            return mimeType;
        }
        return this.identifier.identify(firstBytes, fileName, uri);
    }
}

