/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.access.AccessControlException;
import com.googlecode.fascinator.api.access.AccessControlManager;
import com.googlecode.fascinator.api.access.AccessControlSchema;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.SAXReader;
import org.ontoware.rdf2go.Reasoning;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.impl.jena24.ModelImplJena24;
import org.ontoware.rdf2go.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonUtils {
    private static Logger log = LoggerFactory.getLogger(PythonUtils.class);
    private AccessControlManager access;
    private Map<String, String> namespaces;
    private SAXReader saxReader;
    private ActiveMQConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private Map<String, Destination> destinations;
    private static final Set<String> majors = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("audio", "video", "image")));
    private static final Set<String> wordMinors = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("vnd.ms-word", "vnd.oasis.opendocument.text", "vnd.openxmlformats-officedocument.wordprocessingml")));
    private static final Set<String> pptMinors = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("vnd.ms-powerpoint", "vnd.oasis.opendocument.presentation", "vnd.openxmlformats-officedocument.presentationml")));

    public PythonUtils(JsonSimpleConfig config) throws PluginException {
        String accessControlType = "accessmanager";
        this.access = PluginManager.getAccessManager((String)accessControlType);
        this.access.init(config.toString());
        this.namespaces = new HashMap<String, String>();
        DocumentFactory docFactory = new DocumentFactory();
        docFactory.setXPathNamespaceURIs(this.namespaces);
        this.saxReader = new SAXReader(docFactory);
        String brokerUrl = config.getString("tcp://localhost:61616", "messaging", "url");
        this.connectionFactory = new ActiveMQConnectionFactory(brokerUrl);
        try {
            this.connection = this.connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer(null);
            this.producer.setDeliveryMode(2);
            this.destinations = new HashMap<String, Destination>();
        }
        catch (JMSException ex) {
            throw new PluginException((Throwable)ex);
        }
    }

    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jmse) {
                log.warn("Failed to close connection: {}", (Object)jmse.getMessage());
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException jmse) {
                log.warn("Failed to close session: {}", (Object)jmse.getMessage());
            }
        }
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException jmse) {
                log.warn("Failed to close producer: {}", (Object)jmse.getMessage());
            }
        }
        if (this.access != null) {
            try {
                this.access.shutdown();
            }
            catch (PluginException ex) {
                log.warn("Failed shutting down access control manager:", (Throwable)ex);
            }
        }
    }

    public boolean sendMessage(String messageQueue, String message) {
        try {
            this.sendMessage(this.getDestination(messageQueue, true), message);
            return true;
        }
        catch (JMSException jmse) {
            log.error("Failed to queue message", (Throwable)jmse);
            return false;
        }
    }

    private void sendMessage(Destination destination, String msg) throws JMSException {
        TextMessage message = this.session.createTextMessage(msg);
        this.producer.send(destination, (Message)message);
    }

    private Destination getDestination(String name, boolean queue) throws JMSException {
        Destination destination = this.destinations.get(name);
        if (destination == null) {
            destination = queue ? this.session.createQueue(name) : this.session.createTopic(name);
            this.destinations.put(name, destination);
        }
        return destination;
    }

    public InputStream getResource(String path) {
        return this.getClass().getResourceAsStream(path);
    }

    public Document getXmlDocument(Payload payload) {
        try {
            Document doc = this.getXmlDocument(payload.open());
            payload.close();
            return doc;
        }
        catch (StorageException ex) {
            log.error("Failed to access payload", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocument(String xmlData) {
        Reader reader = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xmlData.getBytes("utf-8"));
            Document document = this.saxReader.read((InputStream)in);
            return document;
        }
        catch (UnsupportedEncodingException uee) {
        }
        catch (DocumentException de) {
            log.error("Failed to parse XML", (Throwable)de);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocument(InputStream xmlIn) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(xmlIn, "UTF-8");
            Document document = this.saxReader.read((Reader)reader);
            return document;
        }
        catch (UnsupportedEncodingException uee) {
        }
        catch (DocumentException de) {
            log.error("Failed to parse XML", (Throwable)de);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void registerNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public void unregisterNamespace(String prefix) {
        this.namespaces.remove(prefix);
    }

    public JsonSimple getJsonObject(InputStream in) {
        try {
            return new JsonSimple(in);
        }
        catch (IOException ex) {
            log.error("Failure during stream access", (Throwable)ex);
            return null;
        }
    }

    public Model getRdfModel(Payload payload) {
        try {
            Model model = this.getRdfModel(payload.open());
            payload.close();
            return model;
        }
        catch (StorageException ioe) {
            log.info("Failed to read payload stream", (Throwable)ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getRdfModel(InputStream rdfIn) {
        ModelImplJena24 model = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(rdfIn, "UTF-8");
            model = new ModelImplJena24(Reasoning.rdfs);
            model.open();
            model.readFrom((Reader)reader);
        }
        catch (ModelRuntimeException mre) {
            log.error("Failed to create RDF model", (Throwable)mre);
        }
        catch (IOException ioe) {
            log.error("Failed to read RDF input", (Throwable)ioe);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ioe) {}
            }
        }
        return model;
    }

    public AccessControlSchema getAccessSchema(String plugin) {
        if (this.access == null) {
            return null;
        }
        this.access.setActivePlugin(plugin);
        return this.access.getEmptySchema();
    }

    public void setAccessSchema(AccessControlSchema schema, String plugin) {
        if (this.access == null) {
            return;
        }
        try {
            this.access.setActivePlugin(plugin);
            this.access.applySchema(schema);
        }
        catch (AccessControlException ex) {
            log.error("Failed to add new access schema", (Throwable)ex);
        }
    }

    public void removeAccessSchema(AccessControlSchema schema, String plugin) {
        if (this.access == null) {
            return;
        }
        try {
            this.access.setActivePlugin(plugin);
            this.access.removeSchema(schema);
        }
        catch (AccessControlException ex) {
            log.error("Failed to revoke existing access schema", (Throwable)ex);
        }
    }

    public List<String> getRolesWithAccess(String recordId) {
        if (this.access == null) {
            return null;
        }
        try {
            return this.access.getRoles(recordId);
        }
        catch (AccessControlException ex) {
            log.error("Failed to query security plugin for roles", (Throwable)ex);
            return null;
        }
    }

    public List<String> getRolesWithAccess(String recordId, String plugin) {
        if (this.access == null) {
            return null;
        }
        try {
            ArrayList<String> roles = new ArrayList<String>();
            this.access.setActivePlugin(plugin);
            List schemas = this.access.getSchemas(recordId);
            for (AccessControlSchema schema : schemas) {
                String role = schema.get("role");
                if (role == null) continue;
                roles.add(role);
            }
            return roles;
        }
        catch (AccessControlException ex) {
            log.error("Failed to query security plugin for roles", (Throwable)ex);
            return null;
        }
    }

    public List<String> getUsersWithAccess(String recordId) {
        if (this.access == null) {
            return null;
        }
        try {
            return this.access.getUsers(recordId);
        }
        catch (AccessControlException ex) {
            log.error("Failed to query security plugin for roles", (Throwable)ex);
            return null;
        }
    }

    public List<String> getUsersWithAccess(String recordId, String plugin) {
        if (this.access == null) {
            return null;
        }
        try {
            ArrayList<String> users = new ArrayList<String>();
            this.access.setActivePlugin(plugin);
            List schemas = this.access.getSchemas(recordId);
            for (AccessControlSchema schema : schemas) {
                String user = schema.get("user");
                if (user == null) continue;
                users.add(user);
            }
            return users;
        }
        catch (AccessControlException ex) {
            log.error("Failed to query security plugin for roles", (Throwable)ex);
            return null;
        }
    }

    public String getDisplayMimeType(String[] indexerFormats, DigitalObject object, String preview) {
        String result = indexerFormats[0];
        if (preview != null) {
            try {
                Payload payload = object.getPayload(preview);
                PayloadType type = payload.getType();
                if (type != null && type.equals((Object)PayloadType.Preview) && payload.getContentType() != null) {
                    result = payload.getContentType();
                }
            }
            catch (StorageException ex) {
                log.error("Error accessing payload: '{}'", (Object)preview, (Object)ex);
            }
        }
        return result;
    }

    public String basicDisplayType(String mimeType) {
        String[] parts = mimeType.split("/");
        if (parts == null || parts.length != 2) {
            return "default";
        }
        String major = parts[0];
        String minor = parts[1];
        if (majors.contains(major)) {
            return major;
        }
        if (major.equals("application")) {
            if (minor.equals("pdf")) {
                return minor;
            }
            if (wordMinors.contains(minor)) {
                return "word-processing";
            }
            if (pptMinors.contains(minor)) {
                return "presentation";
            }
            if (minor.equals("x-fascinator-package")) {
                return "package";
            }
        }
        if (major.equals("text")) {
            return minor;
        }
        return "default";
    }

    public void add(Map<String, List<String>> index, String field, String value) {
        if (index.containsKey(field)) {
            index.get(field).add(value);
        } else {
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(value);
            index.put(field, newList);
        }
    }

    public String solrDocument(Map<String, List<String>> fields) {
        String result = "<doc>";
        for (String field : fields.keySet()) {
            for (String value : fields.get(field)) {
                result = result + this.solrField(field, value);
            }
        }
        result = result + "</doc>";
        return result;
    }

    public String solrField(String field, String value) {
        if (field == null || value == null) {
            return null;
        }
        return "<field name=\"" + field + "\">" + StringEscapeUtils.escapeXml((String)value) + "</field>";
    }
}

