/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.MagicMimeTypeIdentifierWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifier;
import org.semanticdesktop.aperture.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeUtil {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static Logger log = LoggerFactory.getLogger(MimeTypeUtil.class);
    private static MimeTypeIdentifier identifier = new MagicMimeTypeIdentifierWrapper();

    public static String getMimeType(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return MimeTypeUtil.getMimeType(file);
        }
        String mimeType = identifier.identify(null, filename, null);
        if (mimeType == null) {
            mimeType = DEFAULT_MIME_TYPE;
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] inBytes = IOUtil.readBytes((InputStream)in, (int)identifier.getMinArrayLength());
            ((InputStream)in).close();
            String string = identifier.identify(inBytes, file.getName(), null);
            return string;
        }
        catch (IOException ioe) {
            log.warn("Failed to detect MIME type (File): {}", (Object)MimeTypeUtil.toPrintable(ioe));
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return DEFAULT_MIME_TYPE;
    }

    public static String getMimeType(InputStream in) {
        try {
            byte[] inBytes = IOUtil.readBytes((InputStream)in, (int)identifier.getMinArrayLength());
            in.close();
            return identifier.identify(inBytes, null, null);
        }
        catch (IOException ioe) {
            log.warn("Failed to detect MIME type (InputStream): {}", (Object)MimeTypeUtil.toPrintable(ioe));
            return DEFAULT_MIME_TYPE;
        }
    }

    public static String getMimeType(byte[] bytes, String filename) {
        return identifier.identify(bytes, filename, null);
    }

    private static String toPrintable(Exception e) {
        String msg = e.getMessage();
        if (StringUtils.isAsciiPrintable((String)msg)) {
            return msg;
        }
        return StringUtils.left((String)msg.replaceAll("[^\\p{ASCII}\\n]", "."), (int)32);
    }
}

