/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.transaction;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.transaction.TransactionException;
import com.googlecode.fascinator.api.transaction.TransactionManager;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;

public abstract class GenericTransactionManager
implements TransactionManager {
    private String id;
    private String name;
    private JsonSimpleConfig config;

    public GenericTransactionManager(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.init();
        }
        catch (IOException ioe) {
            throw new TransactionException((Throwable)ioe);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.init();
        }
        catch (IOException ioe) {
            throw new TransactionException((Throwable)ioe);
        }
    }

    public abstract void init() throws TransactionException;

    public void shutdown() throws PluginException {
    }

    public JsonSimpleConfig getJsonConfig() throws TransactionException {
        if (this.config == null) {
            try {
                this.config = new JsonSimpleConfig();
            }
            catch (IOException ioe) {
                throw new TransactionException((Throwable)ioe);
            }
        }
        return this.config;
    }

    public final Object parseMessage(Object message) throws TransactionException {
        if (message instanceof JsonSimple) {
            return this.parseMessage((JsonSimple)message);
        }
        throw new TransactionException("Invalid message format recieved. JsonSimple required.");
    }

    public abstract JsonSimple parseMessage(JsonSimple var1) throws TransactionException;
}

