/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class FascinatorPropertyPlaceHolderConfigurer
extends PropertyPlaceholderConfigurer {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            Properties configProperties = this.mapJsonToProperties(config);
            this.addConfigPropertiesToLocalPropertiesArray(configProperties);
            Properties mergedProps = this.mergeProperties();
            this.convertProperties(mergedProps);
            this.processProperties(beanFactory, mergedProps);
        }
        catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", (Throwable)ex);
        }
    }

    private void addConfigPropertiesToLocalPropertiesArray(Properties configProperties) {
        try {
            Field localPropertiesField = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSuperclass().getDeclaredField("localProperties");
            localPropertiesField.setAccessible(true);
            Properties[] localProperties = (Properties[])localPropertiesField.get((Object)this);
            List<Object> propertyList = new ArrayList<Properties>();
            if (localProperties != null) {
                propertyList = Arrays.asList(localProperties);
            }
            propertyList.add(0, configProperties);
            localPropertiesField.set((Object)this, propertyList.toArray(new Properties[0]));
        }
        catch (NoSuchFieldException e) {
            throw new BeanInitializationException("Could not load properties", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new BeanInitializationException("Could not load properties", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BeanInitializationException("Could not load properties", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInitializationException("Could not load properties", (Throwable)e);
        }
    }

    private Properties mapJsonToProperties(JsonSimpleConfig config) {
        Properties properties = new Properties();
        JsonObject obj = config.getJsonObject();
        for (Object o : obj.keySet()) {
            String key = (String)o;
            Object value = obj.get(key);
            if (value instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (!(value instanceof JsonObject)) continue;
            this.processJsonObjectToProperties((JsonObject)value, key, properties);
        }
        return properties;
    }

    private void processJsonObjectToProperties(JsonObject jsonObject, String parentKey, Properties properties) {
        for (Object o : jsonObject.keySet()) {
            String key = (String)o;
            Object value = jsonObject.get(key);
            if (value instanceof String) {
                properties.put(parentKey + "." + key, value);
                continue;
            }
            if (!(value instanceof JsonObject)) continue;
            this.processJsonObjectToProperties((JsonObject)value, parentKey + "." + key, properties);
        }
    }
}

