/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.solr.SolrDoc;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAndPayloadComposite {
    private SolrDoc indexedData;
    private JsonSimple payloadData;
    private static Logger log = LoggerFactory.getLogger(IndexAndPayloadComposite.class);

    public IndexAndPayloadComposite(SolrDoc indexedData, JsonSimple payloadData) {
        this.indexedData = indexedData;
        this.payloadData = payloadData;
    }

    public Object getPath(String field) {
        String convertedFieldName;
        Object object = null;
        if (field.indexOf("_") != -1 && (object = this.getPath(convertedFieldName = field.replace("_", ":"))) != null) {
            return object;
        }
        if (this.payloadData != null) {
            object = this.payloadData.getPath(field);
        }
        if (object == null) {
            object = this.indexedData.getPath(field);
        }
        return object;
    }

    public String get(String field) {
        Object object = this.getPath(field);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            List<String> array = JsonSimple.getStringList((JSONArray)object);
            if (array.size() == 1) {
                return array.get(0);
            }
            return "[\"" + StringUtils.join(array, (String)"\", \"") + "\"]";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Double) {
            return Double.toString((Double)object);
        }
        return null;
    }

    public String getFirst(String field) {
        List<String> array;
        String first;
        Object object = this.getPath(field);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray && (first = (array = JsonSimple.getStringList((JSONArray)object)).get(0)) instanceof String) {
            return first;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public List<String> getList(String field) {
        Object object = this.getPath(field);
        if (object == null) {
            return new LinkedList<String>();
        }
        if (object instanceof JSONArray) {
            return JsonSimple.getStringList((JSONArray)object);
        }
        if (object instanceof String) {
            LinkedList<String> response = new LinkedList<String>();
            response.add((String)object);
            return response;
        }
        return null;
    }

    public JsonObject getJsonObject() {
        if (this.payloadData != null) {
            return this.payloadData.getJsonObject();
        }
        return this.indexedData.getJsonObject();
    }

    public SolrDoc getIndexedData() {
        return this.indexedData;
    }

    public JsonSimple getPayloadData() {
        return this.payloadData;
    }

    public void setPayloadData(JsonSimple payloadData) {
        this.payloadData = payloadData;
    }
}

