/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.authentication;

import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.common.JsonObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUser
implements User {
    private Logger log = LoggerFactory.getLogger(GenericUser.class);
    private JsonObject response;
    protected String username;
    protected String authenticationSource;
    private Map<String, String> additionalAttributesMap = new HashMap<String, String>();

    public final String describeMetadata() {
        String class_name = this.getClass().getCanonicalName();
        try {
            Class<?> ref_class = Class.forName(class_name);
            Field[] field_list = ref_class.getDeclaredFields();
            this.response = new JsonObject();
            this.response.put("username", "String");
            for (Field element : field_list) {
                this.response.put(element.getName(), element.getType().getSimpleName());
            }
            for (String key : this.additionalAttributesMap.keySet()) {
                this.response.put(key, "String");
            }
            return this.response.toString();
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Error retrieving user specification", (Throwable)ex);
            return "Error retrieving user specification";
        }
    }

    public final String get(String property) {
        String class_name = this.getClass().getCanonicalName();
        try {
            Field[] field_list;
            Class<?> ref_class = Class.forName(class_name);
            for (Field element : field_list = ref_class.getDeclaredFields()) {
                if (!property.equals(element.getName())) continue;
                try {
                    if (element.get(this) != null) {
                        return element.get(this).toString();
                    }
                    return null;
                }
                catch (IllegalArgumentException ex) {
                    this.log.error("User Object, Illegal argument : {}", (Throwable)ex);
                    return null;
                }
                catch (IllegalAccessException ex) {
                    this.log.error("User Object, Illegal access : {}", (Throwable)ex);
                    return null;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Error accessing user data", (Throwable)ex);
            return null;
        }
        return this.additionalAttributesMap.get(property);
    }

    public final void set(String property, String value) {
        String class_name = this.getClass().getCanonicalName();
        try {
            Class<?> ref_class = Class.forName(class_name);
            Field[] field_list = ref_class.getDeclaredFields();
            boolean foundElement = false;
            for (Field element : field_list) {
                if (!property.equals(element.getName())) continue;
                try {
                    element.set(this, value);
                    foundElement = true;
                    break;
                }
                catch (IllegalArgumentException ex) {
                    this.log.error("Security Object, Illegal argument : {}", (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    this.log.error("Security Object, Illegal access : {}", (Throwable)ex);
                }
            }
            if (!foundElement) {
                this.additionalAttributesMap.put(property, value);
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Error setting user data", (Throwable)ex);
            return;
        }
    }

    public String realName() {
        return this.username;
    }

    public void setUsername(String newName) {
        this.username = newName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setSource(String plugin) {
        this.authenticationSource = plugin;
    }

    public String getSource() {
        return this.authenticationSource;
    }
}

