/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.authentication.hibernate;

import com.googlecode.fascinator.common.authentication.hibernate.HibernateUser;
import com.googlecode.fascinator.common.authentication.hibernate.HibernateUserAttribute;
import com.googlecode.fascinator.dao.GenericDao;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="hibernateAuthUserService")
public class HibernateUserService {
    @Autowired
    private GenericDao<HibernateUser, Long> hibernateAuthUserDao;
    @Autowired
    private GenericDao<HibernateUserAttribute, Long> hibernateAuthUserAttributeDao;
    private final Logger log = LoggerFactory.getLogger(HibernateUserService.class);

    @Transactional
    public synchronized void addUser(HibernateUser user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", user.getUsername());
        params.put("source", user.getSource());
        List<HibernateUser> users = this.hibernateAuthUserDao.query("getUserWithSource", params);
        if (users.size() == 0) {
            this.hibernateAuthUserDao.create(user);
        } else {
            HibernateUser fromdb = users.get(0);
            if (!user.getSource().equalsIgnoreCase(fromdb.getSource())) {
                throw new RuntimeException("Username exists in the database from a different source");
            }
            fromdb.mergeAttributes(user);
            this.saveUser(fromdb);
        }
    }

    @Transactional
    public synchronized void saveUser(HibernateUser user) {
        this.hibernateAuthUserDao.update(user);
    }

    @Transactional
    public synchronized HibernateUser getUser(String username) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        List<HibernateUser> users = this.hibernateAuthUserDao.query("getUser", params);
        if (users.size() == 0) {
            return null;
        }
        HibernateUser user = users.get(0);
        user.getAttributes();
        return user;
    }
}

