/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.solr;

import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.IndexerException;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="fascinatorIndexer")
public class SpringIndexerWrapper
implements Indexer {
    private Indexer indexerPlugin;
    private static final String DEFAULT_STORAGE_TYPE = "solr";
    private Logger log = LoggerFactory.getLogger(SpringIndexerWrapper.class);

    public SpringIndexerWrapper() {
        JsonSimpleConfig systemConfiguration;
        try {
            systemConfiguration = new JsonSimpleConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String indexerType = systemConfiguration.getString(DEFAULT_STORAGE_TYPE, "indexer", "type");
        this.indexerPlugin = PluginManager.getIndexer((String)indexerType);
        if (this.indexerPlugin == null) {
            throw new RuntimeException("Indexer plugin '" + indexerType + "' not found. Ensure it is in the classpath.");
        }
        try {
            this.indexerPlugin.init(systemConfiguration.toString());
            this.log.debug("Indexer service has been initialiased: {}", (Object)this.indexerPlugin.getName());
        }
        catch (PluginException pe) {
            throw new RuntimeException("Failed to initialise index", pe);
        }
    }

    public String getId() {
        return this.indexerPlugin.getId();
    }

    public String getName() {
        return this.indexerPlugin.getName();
    }

    public PluginDescription getPluginDetails() {
        return this.indexerPlugin.getPluginDetails();
    }

    public void init(File jsonFile) throws PluginException {
        this.indexerPlugin.init(jsonFile);
    }

    public void init(String jsonString) throws PluginException {
        this.indexerPlugin.init(jsonString);
    }

    public void shutdown() throws PluginException {
        this.indexerPlugin.shutdown();
    }

    public void annotate(String arg0, String arg1) throws IndexerException {
        this.indexerPlugin.annotate(arg0, arg1);
    }

    public void annotateRemove(String arg0) throws IndexerException {
        this.indexerPlugin.annotateRemove(arg0);
    }

    public void annotateRemove(String arg0, String arg1) throws IndexerException {
        this.indexerPlugin.annotate(arg0, arg1);
    }

    public void annotateSearch(SearchRequest arg0, OutputStream arg1) throws IndexerException {
        this.indexerPlugin.annotateSearch(arg0, arg1);
    }

    public void commit() {
        this.indexerPlugin.commit();
    }

    public void index(String arg0) throws IndexerException {
        this.indexerPlugin.index(arg0);
    }

    public void index(String arg0, String arg1) throws IndexerException {
        this.indexerPlugin.index(arg0, arg1);
    }

    public void remove(String arg0) throws IndexerException {
        this.indexerPlugin.remove(arg0);
    }

    public void remove(String arg0, String arg1) throws IndexerException {
        this.indexerPlugin.remove(arg0, arg1);
    }

    public void search(SearchRequest arg0, OutputStream arg1) throws IndexerException {
        this.indexerPlugin.search(arg0, arg1);
    }

    public void search(SearchRequest arg0, OutputStream arg1, String arg2) throws IndexerException {
        this.indexerPlugin.search(arg0, arg1, arg2);
    }

    public void searchByIndex(SearchRequest arg0, OutputStream arg1, String arg2) throws IndexerException {
        this.indexerPlugin.searchByIndex(arg0, arg1, arg2);
    }

    public List<Object> getJsonObjectWithField(String fieldName, String fieldValue) throws IndexerException {
        return this.indexerPlugin.getJsonObjectWithField(fieldName, fieldValue);
    }
}

