/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ManifestNode
extends JsonSimple {
    private String parentKey;
    private String thisKey;

    public ManifestNode() {
        super(new JsonObject());
    }

    public ManifestNode(JsonObject newJsonObject) {
        super(newJsonObject);
    }

    public String getKey() {
        return this.thisKey;
    }

    public void setKey(String newKey) {
        this.thisKey = newKey;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String newParent) {
        this.parentKey = newParent;
    }

    public boolean addChild(String id, String title) {
        if (id == null || title == null) {
            return false;
        }
        String key = "node-" + id;
        ManifestNode node = new ManifestNode();
        node.setId(id);
        node.setTitle(title);
        node.setKey(key);
        node.setParentKey(this.thisKey);
        JsonObject object = this.writeObject("children");
        object.put(key, node.getJsonObject());
        return true;
    }

    public boolean hasChildren() {
        JsonObject object = this.getObject("children");
        return object != null;
    }

    public List<ManifestNode> getChildren() {
        ArrayList<ManifestNode> response = new ArrayList<ManifestNode>();
        Map<String, JsonSimple> children = this.getJsonSimpleMap("children");
        if (children == null) {
            return response;
        }
        for (String key : children.keySet()) {
            ManifestNode manNode = new ManifestNode(children.get(key).getJsonObject());
            manNode.setParentKey(this.getKey());
            manNode.setKey(key);
            response.add(manNode);
        }
        return response;
    }

    public boolean getHidden() {
        return this.getBoolean(false, "hidden");
    }

    public void setHidden(boolean hidden) {
        this.getJsonObject().put("hidden", hidden);
    }

    public String getId() {
        return this.getString(null, "id");
    }

    public void setId(String id) {
        this.getJsonObject().put("id", id);
    }

    public String getTitle() {
        return this.getString(null, "title");
    }

    public void setTitle(String title) {
        this.getJsonObject().put("title", title);
    }
}

