/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utf8StringDebug {
    private static Logger log = LoggerFactory.getLogger(Utf8StringDebug.class);

    public static void debugString(String newString) {
        Utf8StringDebug.debugString(newString, 1);
    }

    public static void debugString(String newString, int limit) {
        log.debug("Decoding String\n=============\n" + newString + "\n=============\n" + Utf8StringDebug.displayString(newString, limit));
    }

    public static String displayString(String newString, int limit) {
        if (newString.length() == 0) {
            return "";
        }
        String output = "";
        String firstChar = newString.substring(0, 1);
        try {
            byte[] utf8Bytes = firstChar.getBytes("UTF8");
            output = output + Utf8StringDebug.printBytes(utf8Bytes, firstChar, limit);
        }
        catch (UnsupportedEncodingException ex) {
            log.error("Error decoding character '" + firstChar + "' : ", (Throwable)ex);
        }
        output = output + Utf8StringDebug.displayString(newString.substring(1), limit);
        return output;
    }

    public static String printBytes(byte[] array, String name, int limit) {
        String output = "";
        if (array.length > limit) {
            output = output + "'" + name + "' =>";
            for (byte element : array) {
                output = output + " 0x" + Utf8StringDebug.byteToHex(element);
            }
            output = output + "\n";
        }
        return output;
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }
}

