/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.JsonConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfig {
    private static Logger log = LoggerFactory.getLogger(JsonConfig.class);
    private static final String CONFIG_DIR = FascinatorHome.getPath();
    private static final String SYSTEM_CONFIG_FILE = "system-config.json";
    private JsonConfigHelper systemConfig;
    private JsonConfigHelper userConfig;

    public JsonConfig() throws IOException {
        this((InputStream)null);
    }

    public JsonConfig(File jsonFile) throws IOException {
        this(new FileInputStream(jsonFile));
    }

    public JsonConfig(InputStream jsonIn) throws IOException {
        this.userConfig = jsonIn == null ? new JsonConfigHelper() : new JsonConfigHelper(jsonIn);
        this.systemConfig = new JsonConfigHelper(JsonConfig.getSystemFile());
    }

    public JsonConfig(String jsonString) throws IOException {
        this(new ByteArrayInputStream(jsonString.getBytes("UTF-8")));
    }

    public String get(String path) {
        return this.get(path, null);
    }

    public String get(String path, String defaultValue) {
        String value = this.userConfig.get(path);
        if (value == null) {
            value = this.systemConfig.get(path, defaultValue);
        }
        return value;
    }

    public List<Object> getList(String path) {
        List<Object> valueList = this.userConfig.getList(path);
        if (valueList.isEmpty()) {
            valueList = this.systemConfig.getList(path);
        }
        return valueList;
    }

    public Map<String, Object> getMap(String path) {
        Map<String, Object> valueMap = this.userConfig.getMap(path);
        if (valueMap.isEmpty()) {
            valueMap = this.systemConfig.getMap(path);
        }
        return valueMap;
    }

    public Map<String, Object> getMapWithChild(String path) {
        Map<String, Object> valueMap = this.userConfig.getMapWithChild(path);
        if (valueMap.isEmpty()) {
            valueMap = this.systemConfig.getMapWithChild(path);
        }
        return valueMap;
    }

    public void set(String path, String value, boolean system) {
        if (system) {
            this.systemConfig.set(path, value);
        } else {
            this.userConfig.set(path, value);
        }
    }

    public void store(Writer writer) throws IOException {
        this.store(writer, false);
    }

    public void store(Writer writer, boolean pretty) throws IOException {
        this.userConfig.store(writer, pretty);
        FileWriter sysWriter = new FileWriter(JsonConfig.getSystemFile());
        this.systemConfig.store(sysWriter, pretty);
        sysWriter.close();
    }

    public static File backupSystemFile() throws IOException {
        File configFile = new File(CONFIG_DIR, SYSTEM_CONFIG_FILE);
        File backupFile = new File(CONFIG_DIR, "system-config.json.old");
        if (!configFile.exists()) {
            throw new IOException("System file does not exist! '" + configFile.getAbsolutePath() + "'");
        }
        if (backupFile.exists()) {
            backupFile.delete();
        }
        FileOutputStream out = new FileOutputStream(backupFile);
        FileInputStream in = new FileInputStream(configFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
        log.info("Configuration copied to '{}'", (Object)backupFile);
        return backupFile;
    }

    public static File getSystemFile() throws IOException {
        File configFile = new File(CONFIG_DIR, SYSTEM_CONFIG_FILE);
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(configFile);
            IOUtils.copy((InputStream)JsonConfig.class.getResourceAsStream("/system-config.json"), (OutputStream)out);
            ((OutputStream)out).close();
            log.info("Default configuration copied to '{}'", (Object)configFile);
        }
        return configFile;
    }

    public Map<String, JsonConfigHelper> getJsonMap(String path) {
        Map<String, JsonConfigHelper> value = this.userConfig.getJsonMap(path);
        if (value == null) {
            value = this.systemConfig.getJsonMap(path);
        }
        return value;
    }

    public String toString() {
        return this.userConfig.toString();
    }

    public boolean isConfigured() {
        return Boolean.parseBoolean(this.systemConfig.get("configured"));
    }

    public boolean isOutdated() {
        boolean outdated = false;
        String systemVersion = this.systemConfig.get("version");
        try {
            JsonConfigHelper compiledConfig = new JsonConfigHelper(this.getClass().getResourceAsStream("/system-config.json"));
            String compiledVersion = compiledConfig.get("version");
            boolean bl = outdated = !compiledVersion.equals(systemVersion);
            if (outdated) {
                log.debug("Configuration versions do not match! '{}' != '{}'", (Object)systemVersion, (Object)compiledVersion);
            }
        }
        catch (IOException ioe) {
            log.error("Failed to parse compiled configuration!", (Throwable)ioe);
        }
        return outdated;
    }
}

