/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.authentication.hibernate;

import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.authentication.GenericUser;
import com.googlecode.fascinator.common.authentication.hibernate.HibernateUserAttribute;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="authuser", uniqueConstraints={@UniqueConstraint(columnNames={"username"})})
public class HibernateUser
extends GenericUser {
    private final Logger log = LoggerFactory.getLogger(HibernateUser.class);
    private Long id;
    private Map<String, HibernateUserAttribute> attributes = new HashMap<String, HibernateUserAttribute>();

    public HibernateUser() {
    }

    public HibernateUser(User user) {
        this();
        this.mergeAttributes(user);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(nullable=false)
    public String getUsername() {
        return super.getUsername();
    }

    @Override
    @Column(nullable=false)
    public String getSource() {
        return super.getSource();
    }

    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name="keyStr")
    public Map<String, HibernateUserAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, HibernateUserAttribute> attr) {
        this.attributes = attr;
    }

    public void mergeAttributes(User user) {
        try {
            this.attributes.clear();
            this.setUsername(user.getUsername());
            this.setSource(user.getSource());
            String metaDataStr = user.describeMetadata();
            JsonObject metaMap = new JsonSimple(metaDataStr).getJsonObject();
            for (Object keyObj : metaMap.keySet()) {
                String keyVal = keyObj.toString();
                String valueType = metaMap.get(keyObj).toString();
                if (!"String".equalsIgnoreCase(valueType) || keyVal.equals("username")) continue;
                String value = user.get(keyVal);
                HibernateUserAttribute attr = new HibernateUserAttribute(keyVal, value);
                attr.setUser(this);
                this.attributes.put(keyVal, attr);
                this.set(keyVal, value);
            }
        }
        catch (IOException e) {
            this.log.debug("Error:", (Throwable)e);
        }
    }
}

