/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.storage.impl;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.storage.impl.GenericPayload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDigitalObject
implements DigitalObject {
    private static Logger log = LoggerFactory.getLogger(GenericDigitalObject.class);
    private static String METADATA_LABEL = "The Fascinator Indexer Metadata";
    private static String METADATA_PAYLOAD = "TF-OBJ-META";
    private Map<String, Payload> manifest;
    private Properties metadata;
    private String id;
    private String sourceId;
    private final String DATE_CREATED = "date_object_created";

    public GenericDigitalObject(String id) {
        this.setId(id);
        this.manifest = new HashMap<String, Payload>();
    }

    public Map<String, Payload> getManifest() {
        return this.manifest;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String oid) {
        this.id = oid.replace("\\", "/");
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String pid) {
        this.sourceId = pid;
    }

    public Properties getMetadata() throws StorageException {
        if (this.metadata == null) {
            Map<String, Payload> man = this.getManifest();
            boolean hasMetadataPayload = true;
            if (!man.containsKey(METADATA_PAYLOAD)) {
                hasMetadataPayload = false;
                Set<String> payloadIdList = this.getPayloadIdList();
                for (String string : payloadIdList) {
                    if (!METADATA_PAYLOAD.equals(string)) continue;
                    hasMetadataPayload = true;
                    break;
                }
            }
            if (!hasMetadataPayload) {
                Payload payload = this.createStoredPayload(METADATA_PAYLOAD, IOUtils.toInputStream((String)"# Object Metadata"));
                if (METADATA_PAYLOAD.equals(this.getSourceId())) {
                    this.setSourceId(null);
                }
                payload.setType(PayloadType.Annotation);
                payload.setLabel(METADATA_LABEL);
            }
            try {
                Payload metaPayload = man.get(METADATA_PAYLOAD);
                this.metadata = new Properties();
                InputStream is = metaPayload.open();
                this.metadata.load(is);
                this.metadata.setProperty("metaPid", METADATA_PAYLOAD);
                metaPayload.close();
                is.close();
                log.debug("Closed init metadata input Stream");
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
        return this.metadata;
    }

    public Set<String> getPayloadIdList() {
        return this.getManifest().keySet();
    }

    public Payload createStoredPayload(String pid, InputStream in) throws StorageException {
        GenericPayload payload = this.createPayload(pid, false);
        payload.setInputStream(in);
        return payload;
    }

    public Payload createLinkedPayload(String pid, String linkPath) throws StorageException {
        GenericPayload payload = this.createPayload(pid, true);
        try {
            payload.setInputStream(new ByteArrayInputStream(linkPath.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            throw new StorageException((Throwable)ex);
        }
        return payload;
    }

    private GenericPayload createPayload(String pid, boolean linked) throws StorageException {
        Map<String, Payload> man = this.getManifest();
        if (man.containsKey(pid)) {
            throw new StorageException("ID '" + pid + "' already exists.");
        }
        GenericPayload payload = new GenericPayload(pid);
        if (this.getSourceId() == null) {
            payload.setType(PayloadType.Source);
            this.setSourceId(pid);
        } else {
            payload.setType(PayloadType.Enrichment);
        }
        payload.setLinked(linked);
        man.put(pid, payload);
        return payload;
    }

    public Payload getPayload(String pid) throws StorageException {
        Map<String, Payload> man = this.getManifest();
        if (man.containsKey(pid)) {
            return man.get(pid);
        }
        throw new StorageException("ID '" + pid + "' does not exist.");
    }

    public void removePayload(String pid) throws StorageException {
        Map<String, Payload> man = this.getManifest();
        if (!man.containsKey(pid)) {
            throw new StorageException("ID '" + pid + "' does not exist.");
        }
        man.get(pid).close();
        man.remove(pid);
    }

    public Payload updatePayload(String pid, InputStream in) throws StorageException {
        GenericPayload payload = (GenericPayload)this.getPayload(pid);
        payload.setInputStream(in);
        return payload;
    }

    public void close() throws StorageException {
        Map<String, Payload> man = this.getManifest();
        for (String pid : man.keySet()) {
            man.get(pid).close();
        }
        if (this.metadata != null) {
            if (!man.containsKey(METADATA_PAYLOAD)) {
                throw new StorageException("Metadata payload not found");
            }
            String date_created = (String)this.metadata.get("date_object_created");
            if (date_created == null) {
                date_created = new DateTime().toString();
                this.metadata.put("date_object_created", date_created);
            }
            try {
                ByteArrayOutputStream metaOut = new ByteArrayOutputStream();
                this.metadata.store(metaOut, METADATA_LABEL);
                ByteArrayInputStream in = new ByteArrayInputStream(metaOut.toByteArray());
                this.updatePayload(METADATA_PAYLOAD, in);
                ((InputStream)in).close();
                log.info("Closed metadata inputstream");
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public String toString() {
        return this.getId();
    }
}

