/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.storage.impl;

import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="fascinatorStorage")
public class SpringStorageWrapper
implements Storage {
    private Storage storagePlugin;
    private static final String DEFAULT_STORAGE_TYPE = "file-system";
    private Logger log = LoggerFactory.getLogger(SpringStorageWrapper.class);

    public SpringStorageWrapper() {
        JsonSimpleConfig systemConfiguration;
        try {
            systemConfiguration = new JsonSimpleConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String storageType = systemConfiguration.getString(DEFAULT_STORAGE_TYPE, "storage", "type");
        this.storagePlugin = PluginManager.getStorage((String)storageType);
        if (this.storagePlugin == null) {
            throw new RuntimeException("Storage plugin '" + storageType + "'. Ensure it is in the classpath.");
        }
        try {
            this.storagePlugin.init(systemConfiguration.toString());
            this.log.debug("Storage service has been initialiased: {}", (Object)this.storagePlugin.getName());
        }
        catch (PluginException pe) {
            throw new RuntimeException("Failed to initialise storage", pe);
        }
    }

    public String getId() {
        return this.storagePlugin.getId();
    }

    public String getName() {
        return this.storagePlugin.getName();
    }

    public PluginDescription getPluginDetails() {
        return this.storagePlugin.getPluginDetails();
    }

    public void init(File jsonFile) throws PluginException {
        this.storagePlugin.init(jsonFile);
    }

    public void init(String jsonString) throws PluginException {
        this.storagePlugin.init(jsonString);
    }

    public void shutdown() throws PluginException {
        this.storagePlugin.shutdown();
    }

    public DigitalObject createObject(String oid) throws StorageException {
        return this.storagePlugin.createObject(oid);
    }

    public DigitalObject getObject(String oid) throws StorageException {
        return this.storagePlugin.getObject(oid);
    }

    public void removeObject(String oid) throws StorageException {
        this.storagePlugin.removeObject(oid);
    }

    public Set<String> getObjectIdList() {
        return this.storagePlugin.getObjectIdList();
    }
}

