/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common;

import com.googlecode.fascinator.common.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.json.simple.JSONArray;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSimple {
    private static Logger log = LoggerFactory.getLogger(JsonSimple.class);
    private JsonObject jsonObject;
    private JSONArray jsonArray;
    private boolean substitueProperties = true;

    public JsonSimple() {
        this.jsonObject = new JsonObject();
    }

    public JsonSimple(File jsonFile) throws IOException {
        if (jsonFile == null) {
            this.jsonObject = new JsonObject();
        } else {
            FileInputStream is = new FileInputStream(jsonFile);
            String json = IOUtils.toString((InputStream)is, (String)"UTF-8");
            ((InputStream)is).close();
            this.parse(json);
        }
    }

    public JsonSimple(InputStream jsonIn) throws IOException {
        if (jsonIn == null) {
            this.jsonObject = new JsonObject();
        } else {
            this.parse(IOUtils.toString((InputStream)jsonIn, (String)"UTF-8"));
            jsonIn.close();
        }
    }

    public JsonSimple(String jsonString) throws IOException {
        if (jsonString == null) {
            this.jsonObject = new JsonObject();
        } else {
            this.parse(jsonString);
        }
    }

    public JsonSimple(JsonObject newJsonObject) {
        if (newJsonObject == null) {
            newJsonObject = new JsonObject();
        }
        this.jsonObject = newJsonObject;
    }

    private void parse(String jsonString) throws IOException {
        Object object;
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = new ContainerFactory(){

            public List<?> creatArrayContainer() {
                return new JSONArray();
            }

            public Map<?, ?> createObjectContainer() {
                return new JsonObject();
            }
        };
        try {
            object = parser.parse(jsonString, containerFactory);
        }
        catch (ParseException pe) {
            log.error("JSON Parse Error: attempting to parse json string: {}: {}", (Object)jsonString, (Object)pe);
            throw new IOException(pe);
        }
        if (object instanceof JsonObject) {
            this.jsonObject = (JsonObject)object;
        } else if (object instanceof JSONArray) {
            this.jsonArray = (JSONArray)object;
            this.jsonObject = this.getFromArray((JSONArray)object);
        } else {
            log.error("Expected JsonObject or at least JSONArray, but found neither. Please check JSON syntax: '{}'", (Object)jsonString);
            this.jsonObject = null;
        }
    }

    public void setPropertySubstitution(boolean newFlag) {
        this.substitueProperties = newFlag;
    }

    private JsonObject getFromArray(JSONArray array) {
        if (array.isEmpty()) {
            log.warn("Found only empty array, starting new object");
            return new JsonObject();
        }
        Object object = array.get(0);
        if (object == null) {
            log.warn("Null entry, starting new object");
            return new JsonObject();
        }
        if (object instanceof JSONArray) {
            return this.getFromArray((JSONArray)object);
        }
        return (JsonObject)object;
    }

    private Object getNode(Object object, Object path) {
        if (this.isArray(object)) {
            try {
                return ((JSONArray)object).get(((Integer)path).intValue());
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        if (this.isObject(object)) {
            return ((JsonObject)object).get(path);
        }
        return null;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public JSONArray getArray(Object ... path) {
        Object object = this.getPath(path);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return null;
    }

    public JsonObject getObject(Object ... path) {
        Object object = this.getPath(path);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        return null;
    }

    public Object getPath(Object ... path) {
        Object object = this.jsonObject;
        boolean valid = true;
        for (Object node : path) {
            if (!this.isValidPath(object, node)) {
                valid = false;
                break;
            }
            object = this.getNode(object, node);
        }
        if (valid) {
            return object;
        }
        return null;
    }

    public Boolean getBoolean(Boolean defaultValue, Object ... path) {
        Object object = this.getPath(path);
        if (object == null) {
            return defaultValue;
        }
        if (this.isNumber(object)) {
            log.warn("getBoolean() : Integer value targeted. Expected Boolean");
            return defaultValue;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    public Integer getInteger(Integer defaultValue, Object ... path) {
        Object object = this.getPath(path);
        if (object == null) {
            return defaultValue;
        }
        if (this.isNumber(object)) {
            return this.makeNumber(object);
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException ex) {
                log.warn("getInteger() : String is not a parsable Integer '{}'", (Object)((String)object));
                return defaultValue;
            }
        }
        if (object instanceof Boolean) {
            log.warn("getInteger() : Boolean value targeted. Expected Integer");
            return defaultValue;
        }
        return null;
    }

    public String getString(String defaultValue, Object ... path) {
        String response = null;
        Object object = this.getPath(path);
        if (object == null) {
            response = defaultValue;
        }
        if (this.isNumber(object)) {
            response = Integer.toString(this.makeNumber(object));
        }
        if (object instanceof String) {
            response = (String)object;
        }
        if (object instanceof Boolean) {
            response = Boolean.toString((Boolean)object);
        }
        if (object instanceof JSONArray) {
            Object value;
            this.jsonArray = (JSONArray)object;
            if (this.jsonArray.size() == 1 && (value = this.jsonArray.get(0)) instanceof String) {
                response = (String)value;
            }
            if (!(response instanceof String)) {
                log.warn("Unable to convert JSONArray: " + object + " to string.");
            }
        }
        if (this.substitueProperties) {
            response = StrSubstitutor.replaceSystemProperties((Object)response);
        }
        return response;
    }

    public List<String> getStringList(Object ... path) {
        Object target = this.getPath(path);
        LinkedList<String> response = new LinkedList<String>();
        if (this.isArray(target)) {
            if (this.substitueProperties) {
                List<String> temp = JsonSimple.getStringList((JSONArray)target);
                for (String string : temp) {
                    response.add(StrSubstitutor.replaceSystemProperties((Object)string));
                }
                return response;
            }
            return JsonSimple.getStringList((JSONArray)target);
        }
        if (this.isString(target)) {
            if (this.substitueProperties) {
                response.add(StrSubstitutor.replaceSystemProperties((Object)((String)target)));
            } else {
                response.add((String)target);
            }
            return response;
        }
        return null;
    }

    public List<JsonSimple> getJsonSimpleList(Object ... path) {
        JSONArray array = this.getArray(path);
        if (this.isArray(array)) {
            return JsonSimple.toJavaList(array);
        }
        return null;
    }

    public Map<String, JsonSimple> getJsonSimpleMap(Object ... path) {
        JsonObject object = this.getObject(path);
        if (this.isObject(object)) {
            return JsonSimple.toJavaMap(object);
        }
        return null;
    }

    public List<Object> search(String node) {
        LinkedList<Object> response = new LinkedList<Object>();
        for (Object key : this.jsonObject.keySet()) {
            Object value = this.jsonObject.get(key);
            if (node.equals((String)key)) {
                response.add(value);
            }
            if (this.isObject(value)) {
                JsonSimple child = new JsonSimple((JsonObject)value);
                response.addAll(child.search(node));
            }
            if (!this.isArray(value)) continue;
            List<JsonSimple> grandChildren = JsonSimple.toJavaList((JSONArray)value);
            for (JsonSimple grandChild : grandChildren) {
                response.addAll(grandChild.search(node));
            }
        }
        return response;
    }

    public JSONArray writeArray(Object ... path) {
        Object response = this.writePath(new JSONArray(), path);
        if (this.isArray(response)) {
            return (JSONArray)response;
        }
        return null;
    }

    public JsonObject writeObject(Object ... path) {
        Object response = this.writePath(new JsonObject(), path);
        if (this.isObject(response)) {
            return (JsonObject)response;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object writePath(Object defaultNode, Object ... path) {
        Object object = this.jsonObject;
        Object child = null;
        for (int i = 0; i < path.length; ++i) {
            Object node = path[i];
            if (!this.isValidPath(object, node)) return null;
            child = this.getNode(object, node);
            if (child == null) {
                int j = i + 1;
                if (j >= path.length) {
                    child = this.writeNode(object, defaultNode, node);
                } else {
                    Object nextNode = path[j];
                    if (this.isString(nextNode)) {
                        child = this.writeNode(object, new JsonObject(), node);
                    } else {
                        if (!this.isNumber(nextNode)) return null;
                        child = this.writeNode(object, new JSONArray(), node);
                    }
                }
            }
            object = child;
        }
        return object;
    }

    private Object writeNode(Object parent, Object newChild, Object nodeName) {
        if (nodeName == null || parent == null) {
            return null;
        }
        if (!this.isValidPath(parent, nodeName)) {
            return null;
        }
        Object oldChild = this.getNode(parent, nodeName);
        if (oldChild != null) {
            return oldChild;
        }
        if (this.isArray(parent) && -1 == (Integer)nodeName) {
            JSONArray array = (JSONArray)parent;
            array.add(newChild);
            return newChild;
        }
        if (this.isObject(parent)) {
            JsonObject object = (JsonObject)parent;
            object.put(nodeName, newChild);
            return newChild;
        }
        return null;
    }

    private boolean isArray(Object object) {
        return object instanceof JSONArray;
    }

    private boolean isNumber(Object object) {
        return object instanceof Integer || object instanceof Long;
    }

    private boolean isObject(Object object) {
        return object instanceof JsonObject;
    }

    private boolean isString(Object object) {
        return object instanceof String;
    }

    private boolean isValidPath(Object object, Object path) {
        if (this.isArray(object) && path instanceof Integer) {
            return true;
        }
        return this.isObject(object) && path instanceof String;
    }

    private Integer makeNumber(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return Integer.parseInt(Long.toString((Long)object));
        }
        return null;
    }

    private String printNode(String label, Object data, String prefix) {
        String output;
        LinkedList<String> lines;
        String tab = "    ";
        String labelString = "";
        if (label != null) {
            labelString = "\"" + label + "\": ";
        }
        String dataString = null;
        if (data instanceof JSONArray) {
            lines = new LinkedList<String>();
            JSONArray array = (JSONArray)data;
            for (Object entry : array) {
                lines.add(this.printNode(null, entry, prefix + tab));
            }
            output = StringUtils.join(lines, (String)",\n");
            dataString = "[\n" + output + "\n" + prefix + "]";
        }
        if (data instanceof JsonObject) {
            lines = new LinkedList();
            JsonObject object = (JsonObject)data;
            for (Object key : object.keySet()) {
                lines.add(this.printNode((String)key, object.get(key), prefix + tab));
            }
            output = StringUtils.join(lines, (String)",\n");
            dataString = "{\n" + output + "\n" + prefix + "}";
        }
        if (data instanceof Boolean) {
            dataString = ((Boolean)data).toString();
        }
        if (data instanceof Long) {
            dataString = ((Long)data).toString();
        }
        if (dataString == null) {
            if (data == null) {
                dataString = "null";
            } else {
                String value = data.toString();
                value = value.replace("\\", "\\\\");
                value = value.replace("\"", "\\\"");
                dataString = "\"" + value + "\"";
            }
        }
        return prefix + labelString + dataString;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean pretty) {
        if (!pretty) {
            return this.jsonObject.toJSONString();
        }
        return this.printNode(null, this.getJsonObject(), "");
    }

    public static List<String> getStringList(JsonObject json, String field) {
        LinkedList<String> response = new LinkedList<String>();
        Object object = json.get(field);
        if (object instanceof JSONArray) {
            return JsonSimple.getStringList((JSONArray)object);
        }
        return response;
    }

    public static List<String> getStringList(JSONArray json) {
        LinkedList<String> response = new LinkedList<String>();
        for (Object obj : json) {
            if (!(obj instanceof String)) continue;
            response.add((String)obj);
        }
        return response;
    }

    public static List<JsonSimple> toJavaList(JSONArray array) {
        LinkedList<JsonSimple> response = new LinkedList<JsonSimple>();
        if (array != null && !array.isEmpty()) {
            for (Object object : array) {
                if (object == null || !(object instanceof JsonObject)) continue;
                response.add(new JsonSimple((JsonObject)object));
            }
        }
        return response;
    }

    public static Map<String, JsonSimple> toJavaMap(JsonObject object) {
        LinkedHashMap<String, JsonSimple> response = new LinkedHashMap<String, JsonSimple>();
        if (object != null && !object.isEmpty()) {
            for (Object key : object.keySet()) {
                Object child = object.get(key);
                if (child == null || !(child instanceof JsonObject)) continue;
                response.put((String)key, new JsonSimple((JsonObject)child));
            }
        }
        return response;
    }

    public static Map<String, JsonObject> fromJavaMap(Map<String, JsonSimple> from) {
        LinkedHashMap<String, JsonObject> response = new LinkedHashMap<String, JsonObject>();
        if (from != null && !from.isEmpty()) {
            for (String key : from.keySet()) {
                response.put(key, from.get(key).getJsonObject());
            }
        }
        return response;
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }
}

