/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.common.storage;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtils {
    public static final String DEFAULT_HOSTNAME = "localhost";
    private static final Logger log = LoggerFactory.getLogger(StorageUtils.class);

    public static String generateOid(File file) {
        String path = FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
        String hostname = DEFAULT_HOSTNAME;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String username = System.getProperty("user.name", "anonymous");
        return DigestUtils.md5Hex((String)(path + hostname + username));
    }

    private static String hashFile(File file) throws IOException {
        return DigestUtils.md5Hex((String)FileUtils.readFileToString((File)file));
    }

    public static String generatePid(File file) {
        return FilenameUtils.separatorsToUnix((String)file.getName());
    }

    public static DigitalObject storeFile(Storage storage, File file) throws StorageException {
        return StorageUtils.storeFile(storage, file, false);
    }

    public static DigitalObject linkFile(Storage storage, File file) throws StorageException {
        return StorageUtils.storeFile(storage, file, true);
    }

    public static DigitalObject storeFile(Storage storage, File file, boolean linked) throws StorageException {
        DigitalObject object = null;
        Payload payload = null;
        String oid = StorageUtils.generateOid(file);
        String pid = StorageUtils.generatePid(file);
        try {
            object = StorageUtils.getDigitalObject(storage, oid);
            if (linked) {
                try {
                    String path = FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
                    payload = StorageUtils.createLinkedPayload(object, pid, path);
                }
                catch (StorageException se) {
                    payload = object.getPayload(pid);
                }
            } else {
                log.debug("Attempting to create or update payload...");
                payload = StorageUtils.createOrUpdatePayload(object, pid, new FileInputStream(file));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new StorageException("File not found '" + oid + "'");
        }
        finally {
            if (payload != null) {
                payload.close();
            }
        }
        return object;
    }

    public static DigitalObject getDigitalObject(Storage storage, String oid) throws StorageException {
        DigitalObject object = null;
        try {
            object = storage.createObject(oid);
        }
        catch (StorageException ex) {
            try {
                object = storage.getObject(oid);
            }
            catch (StorageException ex1) {
                throw new StorageException((Throwable)ex1);
            }
        }
        return object;
    }

    public static Payload getPayload(Storage storage, String oid, String payloadName) throws StorageException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject(storage, oid);
        Payload payload = digitalObject.getPayload(payloadName);
        return payload;
    }

    public static DigitalObject checkHarvestFile(Storage storage, File file) throws StorageException {
        log.debug("Checking for harvest file: {}", (Object)file.getAbsolutePath());
        String oid = StorageUtils.generateOid(file);
        String lastMod = String.valueOf(file.lastModified());
        try {
            DigitalObject object = storage.getObject(oid);
            log.debug("Got harvest file id: {}", (Object)oid);
            try {
                Properties metadata = object.getMetadata();
                String oldMod = metadata.getProperty("lastModified");
                if (oldMod == null || !oldMod.equals(lastMod)) {
                    String oldHash = metadata.getProperty("fileHash");
                    String fileHash = StorageUtils.hashFile(file);
                    if (oldHash == null || !oldHash.equals(fileHash)) {
                        FileInputStream in = new FileInputStream(file);
                        object.updatePayload(object.getSourceId(), (InputStream)in);
                        metadata.setProperty("lastModified", lastMod);
                        metadata.setProperty("fileHash", fileHash);
                        object.close();
                        return object;
                    }
                }
            }
            catch (FileNotFoundException ex1) {
                throw new StorageException("Harvest file not found: ", (Throwable)ex1);
            }
            catch (IOException ex1) {
                throw new StorageException("Error reading harvest file: ", (Throwable)ex1);
            }
            catch (StorageException ex1) {
                throw new StorageException("Error storing harvest file: ", (Throwable)ex1);
            }
        }
        catch (StorageException ex) {
            log.error("There was problem finding a reference or file in storage.", (Throwable)ex);
            try {
                DigitalObject object = StorageUtils.storeFile(storage, file);
                Properties metadata = object.getMetadata();
                metadata.setProperty("lastModified", lastMod);
                metadata.setProperty("fileHash", StorageUtils.hashFile(file));
                object.close();
                return object;
            }
            catch (IOException ex1) {
                throw new StorageException("Error reading harvest file: ", (Throwable)ex1);
            }
            catch (StorageException ex1) {
                throw new StorageException("Error storing harvest file: ", (Throwable)ex1);
            }
        }
        return null;
    }

    public static Payload createOrUpdatePayload(DigitalObject object, String pid, InputStream in) throws StorageException {
        return StorageUtils.createOrUpdatePayload(object, pid, in, null);
    }

    public static Payload createOrUpdatePayload(DigitalObject object, String pid, InputStream in, String filePath) throws StorageException {
        Payload payload = null;
        try {
            payload = filePath == null ? object.createStoredPayload(pid, in) : object.createLinkedPayload(pid, filePath);
        }
        catch (StorageException ex) {
            payload = object.updatePayload(pid, in);
        }
        return payload;
    }

    public static Payload createLinkedPayload(DigitalObject object, String pid, String path) throws StorageException {
        Payload payload = null;
        payload = object.createLinkedPayload(pid, path);
        return payload;
    }
}

