/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Portal
extends JsonSimple {
    public static final String PORTAL_JSON = "portal.json";
    private Logger log = LoggerFactory.getLogger(Portal.class);

    public Portal(String portalName) throws IOException {
        this.setName(portalName);
    }

    public Portal(File portalConfig) throws IOException {
        super(portalConfig);
    }

    public String getName() {
        return this.getString("undefined", new Object[]{"portal", "name"});
    }

    public void setName(String name) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"name", (Object)name.replace(' ', '_'));
    }

    public String getDescription() {
        return this.getString("Undefined", new Object[]{"portal", "description"});
    }

    public void setDescription(String description) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"description", (Object)description);
    }

    public String getQuery() {
        return this.getString("", new Object[]{"portal", "query"});
    }

    public void setQuery(String query) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"query", (Object)query);
    }

    public String getSearchQuery() {
        return this.getString("", new Object[]{"portal", "searchQuery"});
    }

    public void setSearchQuery(String query) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"searchQuery", (Object)query);
    }

    public int getRecordsPerPage() {
        return this.getInteger(10, new Object[]{"portal", "records-per-page"});
    }

    public void setRecordsPerPage(int recordsPerPage) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"records-per-page", (Object)recordsPerPage);
    }

    public int getFacetCount() {
        return this.getInteger(25, new Object[]{"portal", "facet-count"});
    }

    public void setFacetCount(int facetCount) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"facet-count", (Object)facetCount);
    }

    public boolean getFacetSort() {
        return this.getBoolean(false, new Object[]{"portal", "facet-sort-by-count"});
    }

    public void setFacetSort(boolean facetSort) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"facet-sort-by-count", (Object)facetSort);
    }

    public Map<String, JsonSimple> getFacetFields() {
        return JsonSimple.toJavaMap((JsonObject)this.getObject(new Object[]{"portal", "facet-fields"}));
    }

    public void setFacetFields(Map<String, JsonSimple> map) {
        JsonObject facets = this.writeObject(new Object[]{"portal", "facet-fields"});
        for (String key : map.keySet()) {
            facets.put((Object)key, (Object)map.get(key).getJsonObject());
        }
    }

    public List<String> getFacetFieldList() {
        return new ArrayList<String>(this.getFacetFields().keySet());
    }

    public int getFacetDisplay() {
        return this.getInteger(10, new Object[]{"portal", "facet-display"});
    }

    public void setFacetDisplay(int facetDisplay) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"facet-display", (Object)facetDisplay);
    }

    public Map<String, String> getSortFields() {
        JsonObject object = this.getObject(new Object[]{"portal", "sort-fields"});
        LinkedHashMap<String, String> sortFields = new LinkedHashMap<String, String>();
        if (object == null) {
            sortFields.put("last_modified", "Last modified");
            sortFields.put("f_dc_title", "Title");
        } else {
            for (Object key : object.keySet()) {
                sortFields.put((String)key, (String)object.get(key));
            }
        }
        return sortFields;
    }

    public void setSortFields(Map<String, String> sortFields) {
        JsonObject object = this.getObject(new Object[]{"portal", "sort-fields"});
        for (String key : sortFields.keySet()) {
            object.put((Object)key, (Object)sortFields.get(key));
        }
    }

    public List<String> getSortFieldList() {
        return new ArrayList<String>(this.getSortFields().keySet());
    }

    public String getSortFieldDefault() {
        return this.getString("", new Object[]{"portal", "sort-field-default"});
    }

    public void setSortFieldDefault(String sortFieldDefault) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"sort-field-default", (Object)sortFieldDefault);
    }

    public String getSortFieldDefaultOrder() {
        return this.getString("", new Object[]{"portal", "sort-field-default-order"});
    }

    public void setSortFieldDefaultOrder(String sortFieldDefaultOrder) {
        JsonObject portal = this.writeObject(new Object[]{"portal"});
        portal.put((Object)"sort-field-default-order", (Object)sortFieldDefaultOrder);
    }
}

