/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal;

import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.GenericListener;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.portal.UserAction;
import com.googlecode.fascinator.portal.quartz.ExternalJob;
import com.googlecode.fascinator.portal.quartz.HarvestJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HouseKeeper
implements GenericListener {
    public static final String QUEUE_ID = "houseKeeping";
    public static final Integer DEFAULT_TIMEOUT = 300;
    private static String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String DERBY_PROTOCOL = "jdbc:derby:";
    private static String HK_DATABASE = "housekeeping";
    private static String NOTIFICATIONS_TABLE = "notifications";
    private static String DEFAULT_QUARTZ_FILE = "quartz.properties";
    private Logger log = LoggerFactory.getLogger(HouseKeeper.class);
    private JsonSimpleConfig globalConfig;
    private String derbyHome;
    private java.sql.Connection dbConnection;
    private Connection connection;
    private Session pSession;
    private Session cSession;
    private Indexer indexer;
    private Storage storage;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private Queue destHouseKeeping;
    private List<UserAction> actions;
    private Timer timer;
    private long timeout;
    private Thread thread = new Thread((Runnable)this, "houseKeeping");
    private Map<String, Map<String, String>> stats;
    private boolean renderReady = false;
    private Scheduler scheduler;
    private List<JsonSimple> jobConfig;

    private void openLog() {
        MDC.put((String)"name", (String)QUEUE_ID);
    }

    private void closeLog() {
        MDC.remove((String)"name");
    }

    public void run() {
        this.openLog();
        try {
            this.globalConfig = new JsonSimpleConfig();
            String brokerUrl = this.globalConfig.getString("tcp://localhost:61616", new Object[]{"messaging", "url"});
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerUrl);
            this.connection = connectionFactory.createConnection();
            this.cSession = this.connection.createSession(false, 1);
            this.pSession = this.connection.createSession(false, 1);
            Queue destination = this.cSession.createQueue(QUEUE_ID);
            this.consumer = this.cSession.createConsumer((Destination)destination);
            this.consumer.setMessageListener((MessageListener)this);
            this.destHouseKeeping = this.pSession.createQueue(QUEUE_ID);
            this.producer = this.pSession.createProducer(null);
            this.producer.setDeliveryMode(2);
            this.connection.start();
            try {
                this.checkTable(NOTIFICATIONS_TABLE);
                this.syncActionList();
                for (UserAction ua : this.actions) {
                    if (!ua.block) continue;
                    this.removeAction(ua.id);
                }
            }
            catch (SQLException ex) {
                this.log.error("Error during database preparation:", (Throwable)ex);
            }
            this.log.debug("Derby house keeping database online!");
            try {
                this.scheduler = StdSchedulerFactory.getDefaultScheduler();
                this.scheduler.start();
                this.quartzScheduling();
            }
            catch (SchedulerException ex) {
                this.log.error("Scheduled failed to start: ", (Throwable)ex);
            }
            this.log.info("Starting callback timer. Timeout = {}s", (Object)this.timeout);
            this.timer = new Timer("HouseKeeping", true);
            this.timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, this.timeout * 1000L);
        }
        catch (IOException ex) {
            this.log.error("Unable to read config!", (Throwable)ex);
        }
        catch (JMSException ex) {
            this.log.error("Error starting message thread!", (Throwable)ex);
        }
        this.closeLog();
    }

    private java.sql.Connection dbConnection() throws SQLException {
        if (this.dbConnection == null || !this.dbConnection.isValid(1)) {
            if (this.dbConnection != null) {
                this.log.error("!!! Database connection has failed, recreating.");
                try {
                    this.dbConnection.close();
                }
                catch (SQLException ex) {
                    this.log.error("Error closing invalid connection, ignoring: {}", (Object)ex.getMessage());
                }
            }
            Properties props = new Properties();
            try {
                Class.forName(DERBY_DRIVER).newInstance();
            }
            catch (Exception ex) {
                this.log.error("Driver load failed: ", (Throwable)ex);
                throw new SQLException("Driver load failed: ", ex);
            }
            this.dbConnection = DriverManager.getConnection(DERBY_PROTOCOL + HK_DATABASE + ";create=true", props);
        }
        return this.dbConnection;
    }

    private void quartzScheduling() {
        for (JsonSimple thisJob : this.jobConfig) {
            JobDetail job;
            CronTrigger trigger;
            String type;
            String name;
            block14: {
                name = thisJob.getString(null, new Object[]{"name"});
                if (name == null) {
                    this.log.error("Configuration error. All jobs must have a 'name' value.");
                    continue;
                }
                type = thisJob.getString(null, new Object[]{"type"});
                if (type == null) {
                    type = "external";
                }
                if (!type.equals("external") && !type.equals("harvest")) {
                    this.log.error("Unknown job type provided ('{}')", (Object)type);
                    continue;
                }
                trigger = null;
                try {
                    trigger = new CronTrigger(name, null, thisJob.getString(null, new Object[]{"timing"}));
                    this.log.info("Scheduling Job: '{}' => '{}'", (Object)name, (Object)thisJob.getString(null, new Object[]{"timing"}));
                }
                catch (ParseException ex) {
                    this.log.error("Error in job timing ('{}')", (Object)name, (Object)ex);
                    continue;
                }
                job = null;
                if (type.equals("external")) {
                    job = new JobDetail(name, null, ExternalJob.class);
                    String token = thisJob.getString(null, new Object[]{"token"});
                    String urlString = thisJob.getString(null, new Object[]{"url"});
                    if (urlString == null) {
                        this.log.error("No job URL in config ('{}')", (Object)name);
                        continue;
                    }
                    try {
                        URL url = new URL(urlString);
                        job.getJobDataMap().put("url", urlString);
                        if (token == null) break block14;
                        job.getJobDataMap().put("token", token);
                    }
                    catch (MalformedURLException ex) {
                        this.log.error("Invalid URL: '{}'", (Object)urlString, (Object)ex);
                        continue;
                    }
                }
            }
            if (type.equals("harvest")) {
                job = new JobDetail(name, null, HarvestJob.class);
                String configFile = thisJob.getString(null, new Object[]{"configFile"});
                if (configFile == null) {
                    this.log.error("No config path provided ('{}')", (Object)configFile);
                    continue;
                }
                job.getJobDataMap().put("configFile", configFile);
            }
            try {
                this.scheduler.scheduleJob(job, (Trigger)trigger);
            }
            catch (SchedulerException ex) {
                this.log.error("Error scheduling job: ", (Throwable)ex);
            }
        }
    }

    public void init(JsonSimpleConfig config) throws Exception {
        this.openLog();
        try {
            this.log.info("=================");
            this.log.info("Starting House Keeping object");
            this.globalConfig = new JsonSimpleConfig();
            this.timeout = config.getInteger(DEFAULT_TIMEOUT, new Object[]{"config", "frequency"}).intValue();
            this.derbyHome = config.getString(null, new Object[]{"database-service", "derbyHome"});
            String oldHome = System.getProperty("derby.system.home");
            if (oldHome != null) {
                if (this.derbyHome != null) {
                    this.log.warn("Using previously specified data directory: '{}', provided value has been ignored: '{}'", (Object)oldHome, (Object)this.derbyHome);
                } else {
                    this.log.info("Using existing data directory: '{}'", (Object)oldHome);
                }
            } else {
                if (this.derbyHome == null) {
                    this.log.error("No database home directory configured!");
                    return;
                }
                File file = new File(this.derbyHome);
                if (file.exists()) {
                    if (!file.isDirectory()) {
                        throw new Exception("Database home '" + this.derbyHome + "' is not a directory!");
                    }
                } else {
                    file.mkdirs();
                    if (!file.exists()) {
                        throw new Exception("Database home '" + this.derbyHome + "' does not exist and could not be created!");
                    }
                }
                System.setProperty("derby.system.home", this.derbyHome);
            }
            File sysFile = JsonSimpleConfig.getSystemFile();
            this.stats = new LinkedHashMap();
            String quartzConfig = config.getString(null, new Object[]{"config", "quartzConfig"});
            if (quartzConfig == null) {
                throw new Exception("No scheduling config provided: 'config/quartzConfig'!");
            }
            File quartzProps = new File(quartzConfig);
            if (!quartzProps.exists()) {
                this.log.warn("Quartz config file '{}' not found, deploying default", (Object)quartzConfig);
                quartzProps.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(quartzProps);
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/" + DEFAULT_QUARTZ_FILE), (OutputStream)out);
                ((OutputStream)out).close();
                this.log.info("Default configuration copied to '{}'", (Object)quartzProps);
            }
            if (quartzProps != null && quartzProps.exists()) {
                System.setProperty("org.quartz.properties", quartzProps.getAbsolutePath());
            }
            this.jobConfig = JsonSimple.toJavaList((JSONArray)config.getArray(new Object[]{"config", "jobs"}));
            this.indexer = PluginManager.getIndexer((String)this.globalConfig.getString("solr", new Object[]{"indexer", "type"}));
            this.indexer.init(sysFile);
            this.storage = PluginManager.getStorage((String)this.globalConfig.getString("file-system", new Object[]{"storage", "type"}));
            this.storage.init(sysFile);
        }
        catch (IOException ioe) {
            this.log.error("Failed to read configuration: {}", (Object)ioe.getMessage());
            throw ioe;
        }
        catch (PluginException pe) {
            this.log.error("Failed to initialise plugin: {}", (Object)pe.getMessage());
            throw pe;
        }
        finally {
            this.closeLog();
        }
    }

    public String getId() {
        return QUEUE_ID;
    }

    public void start() throws Exception {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        this.openLog();
        this.log.info("Stopping House Keeping object...");
        this.timer.cancel();
        if (this.indexer != null) {
            try {
                this.indexer.shutdown();
            }
            catch (PluginException pe) {
                this.log.error("Failed to shutdown indexer: {}", (Object)pe.getMessage());
                this.closeLog();
                throw pe;
            }
        }
        if (this.storage != null) {
            try {
                this.storage.shutdown();
            }
            catch (PluginException pe) {
                this.log.error("Failed to shutdown storage: {}", (Object)pe.getMessage());
                this.closeLog();
                throw pe;
            }
        }
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close consumer: {}", (Object)jmse.getMessage());
                this.closeLog();
                throw jmse;
            }
        }
        if (this.cSession != null) {
            try {
                this.cSession.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close consumer session: {}", (Throwable)jmse);
            }
        }
        if (this.pSession != null) {
            try {
                this.pSession.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close consumer session: {}", (Throwable)jmse);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close connection: {}", (Throwable)jmse);
            }
        }
        String threadedShutdownMessage = DERBY_DRIVER + " is not registered with the JDBC driver manager";
        try {
            DriverManager.getConnection(DERBY_PROTOCOL + ";shutdown=true");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 50000 && ex.getSQLState().equals("XJ015")) {
            } else if (!ex.getMessage().equals(threadedShutdownMessage)) {
                this.log.warn("Error during database shutdown:", (Throwable)ex);
            }
        }
        finally {
            try {
                if (this.dbConnection != null) {
                    this.dbConnection.close();
                    this.dbConnection = null;
                }
            }
            catch (SQLException ex) {
                this.log.warn("Error closing connection:", (Throwable)ex);
            }
        }
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException ex) {
                this.log.warn("Failed to close connection: {}", (Throwable)ex);
            }
        }
        this.closeLog();
    }

    private void onTimeout() {
        this.openLog();
        if (!Thread.currentThread().getName().equals(this.thread.getName())) {
            Thread.currentThread().setName(this.thread.getName());
            Thread.currentThread().setPriority(this.thread.getPriority());
        }
        this.checkSystemConfig();
        this.syncHarvestFiles();
        this.renderReady = true;
        this.closeLog();
    }

    public void onMessage(Message message) {
        this.openLog();
        try {
            UserAction ua;
            UserAction ua2;
            if (!Thread.currentThread().getName().equals(this.thread.getName())) {
                Thread.currentThread().setName(this.thread.getName());
                Thread.currentThread().setPriority(this.thread.getPriority());
            }
            String text = ((TextMessage)message).getText();
            JsonSimple msgJson = new JsonSimple(text);
            String msgType = msgJson.getString(null, new Object[]{"type"});
            if (msgType == null) {
                this.log.error("No message type set!");
                this.closeLog();
                return;
            }
            if (msgType.equals("blocking-restart")) {
                ua2 = new UserAction();
                ua2.block = true;
                ua2.message = "Changes made to the system require a restart. Please restart the system before normal functionality can resume.";
                this.storeAction(ua2);
            }
            if (msgType.equals("basic-restart")) {
                ua2 = new UserAction();
                ua2.block = false;
                ua2.message = "Changes made to the system require a restart.";
                this.storeAction(ua2);
            }
            if (msgType.equals("harvest-update")) {
                String oid = msgJson.getString(null, new Object[]{"oid"});
                if (oid != null) {
                    ua = new UserAction();
                    ua.block = false;
                    ua.message = "A harvest file has been updated: '" + oid + "'";
                    this.storeAction(ua);
                } else {
                    this.log.error("Invalid message, no harvest file OID provided!");
                }
            }
            if (msgType.equals("user-notice")) {
                String messageText = msgJson.getString(null, new Object[]{"message"});
                if (messageText != null) {
                    ua = new UserAction();
                    ua.block = false;
                    ua.message = messageText;
                    this.storeAction(ua);
                } else {
                    this.log.error("Invalid notice, no message text provided!");
                }
            }
            if (msgType.equals("broker-update")) {
                Map queues = JsonSimple.toJavaMap((JsonObject)msgJson.getObject(new Object[]{"stats"}));
                for (String q : queues.keySet()) {
                    JsonSimple qData = (JsonSimple)queues.get(q);
                    HashMap<String, String> qStats = new HashMap<String, String>();
                    qStats.put("total", qData.getString(null, new Object[]{"total"}));
                    qStats.put("lost", qData.getString(null, new Object[]{"lost"}));
                    qStats.put("memory", qData.getString(null, new Object[]{"memory"}));
                    qStats.put("size", qData.getString(null, new Object[]{"size"}));
                    int spd = Float.valueOf(qData.getString("0.0", new Object[]{"speed"})).intValue();
                    qStats.put("speed", String.valueOf(spd));
                    float avg = Float.valueOf(qData.getString(null, new Object[]{"average"})).floatValue() / 1000.0f;
                    avg = Math.round(avg * 100.0f) / 100;
                    qStats.put("average", String.valueOf(avg));
                    this.stats.put(q, qStats);
                }
            }
            if (msgType.equals("refresh")) {
                this.log.info("Refreshing House Keeping");
                this.globalConfig = new JsonSimpleConfig();
                this.timeout = this.globalConfig.getInteger(DEFAULT_TIMEOUT, new Object[]{"portal", QUEUE_ID, "config", "frequency"}).intValue();
                this.log.info("Starting callback timer. Timeout = {}s", (Object)this.timeout);
                this.timer.cancel();
                this.timer = new Timer("HouseKeeping", true);
                this.timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, this.timeout * 1000L);
                ua2 = new UserAction();
                ua2.block = false;
                ua2.message = "House Keeping is restarting. Frequency = " + this.timeout + "s";
                this.storeAction(ua2);
            }
        }
        catch (JMSException jmse) {
            this.log.error("Failed to receive message: {}", (Object)jmse.getMessage());
        }
        catch (IOException ioe) {
            this.log.error("Failed to parse message: {}", (Object)ioe.getMessage());
        }
        this.closeLog();
    }

    public List<UserAction> getUserMessages() {
        if (!this.renderReady) {
            this.openLog();
            this.log.debug("Holding page render until first house keeping completes.");
            int i = 0;
            while (!this.renderReady && i < 200) {
                ++i;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.renderReady) {
                this.log.debug("Resuming page render (after {} sleeps).", (Object)i);
            } else {
                this.log.error("House keeping has been holding page render for more than 20s and still has not completed. There are likely house keeping errors to address.");
                this.renderReady = true;
            }
            this.closeLog();
        }
        return this.actions;
    }

    public void confirmMessage(String actionId) throws Exception {
        this.openLog();
        int id = -1;
        try {
            id = Integer.parseInt(actionId);
        }
        catch (Exception ex) {
            this.closeLog();
            this.log.error("Invalid message ID provided: ", (Throwable)ex);
            throw new Exception("Invalid message ID provided!");
        }
        boolean found = false;
        for (UserAction ua : this.actions) {
            if (ua.id != id) continue;
            found = true;
            if (!ua.block) continue;
            this.closeLog();
            this.log.error("Trying to delete a blocked message! '{}'", (Object)actionId);
            throw new Exception("Sorry, but you can't delete that message. A restart is required!");
        }
        if (!found) {
            this.closeLog();
            throw new Exception("Message '" + actionId + "' does not exist!");
        }
        try {
            this.removeAction(id);
        }
        catch (SQLException ex) {
            this.closeLog();
            this.log.error("Databases access error: ", (Throwable)ex);
            throw new Exception("Error deleting message, please check administration log files.");
        }
        this.closeLog();
    }

    private void checkSystemConfig() {
        UserAction ua;
        this.log.info("Checking system config files ...");
        boolean fine = true;
        if (this.globalConfig.isOutdated()) {
            fine = false;
            ua = new UserAction();
            ua.block = true;
            ua.message = "out-of-date";
            this.storeAction(ua);
        }
        if (!this.globalConfig.isConfigured()) {
            fine = false;
            ua = new UserAction();
            ua.block = true;
            ua.message = "configure";
            this.storeAction(ua);
        }
        if (fine) {
            this.log.info("... system config files are OK.");
        } else {
            this.log.warn("... problems found in system config files.");
        }
    }

    private void syncHarvestFiles() {
        String harvestPath = this.globalConfig.getString(null, new Object[]{"portal", "harvestFiles"});
        if (harvestPath == null) {
            return;
        }
        File harvestDir = new File(harvestPath);
        if (!harvestDir.exists() || !harvestDir.isDirectory()) {
            return;
        }
        for (File file : this.getFiles(harvestDir)) {
            DigitalObject object = null;
            try {
                object = StorageUtils.checkHarvestFile((Storage)this.storage, (File)file);
            }
            catch (StorageException ex) {
                this.log.error("Error during harvest file check: ", (Throwable)ex);
            }
            if (object == null) continue;
            this.log.debug("Harvest file updated: '{}'", (Object)file.getAbsolutePath());
            JsonObject message = new JsonObject();
            message.put((Object)"type", (Object)"harvest-update");
            message.put((Object)"oid", (Object)object.getId());
            try {
                this.sendMessage((Destination)this.destHouseKeeping, message.toString());
            }
            catch (JMSException ex) {
                this.log.error("Couldn't message House Keeping!", (Throwable)ex);
            }
        }
    }

    private List<File> getFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(this.getFiles(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    private void sendMessage(Destination destination, String message) throws JMSException {
        TextMessage msg = this.pSession.createTextMessage(message);
        this.producer.send(destination, (Message)msg);
    }

    public void setPriority(int newPriority) {
        if (newPriority >= 1 && newPriority <= 10) {
            this.thread.setPriority(newPriority);
        }
    }

    public Map<String, Map<String, String>> getQueueStats() {
        return this.stats;
    }

    private boolean isCurrentAction(String message) {
        for (UserAction ua : this.actions) {
            if (!ua.message.equals(message)) continue;
            return true;
        }
        return false;
    }

    private void removeAction(int id) throws SQLException {
        this.log.debug("Removing action: '{}'", (Object)id);
        CallableStatement sql = this.dbConnection().prepareCall("DELETE FROM " + NOTIFICATIONS_TABLE + " WHERE id = ?");
        sql.setInt(1, id);
        sql.executeUpdate();
        this.close((Statement)sql);
        this.syncActionList();
    }

    private void storeAction(UserAction action) {
        if (this.isCurrentAction(action.message)) {
            return;
        }
        if (action.date == null) {
            action.date = new Date();
        }
        try {
            this.log.debug("Storing action: '{}'", (Object)action.message);
            CallableStatement sql = this.dbConnection().prepareCall("INSERT INTO " + NOTIFICATIONS_TABLE + " (block, message, datetime) VALUES (?, ?, ?)");
            sql.setBoolean(1, action.block);
            sql.setString(2, action.message);
            sql.setTimestamp(3, new Timestamp(action.date.getTime()));
            sql.executeUpdate();
            this.close((Statement)sql);
            this.syncActionList();
        }
        catch (SQLException ex) {
            this.log.error("Error accessing database: ", (Throwable)ex);
        }
    }

    private void syncActionList() {
        this.actions = new ArrayList();
        try {
            CallableStatement sql = this.dbConnection().prepareCall("SELECT * FROM " + NOTIFICATIONS_TABLE + " ORDER BY block DESC, id");
            ResultSet result = sql.executeQuery();
            while (result.next()) {
                UserAction ua = new UserAction();
                ua.id = result.getInt("id");
                ua.block = result.getBoolean("block");
                ua.message = result.getString("message");
                ua.date = new Date(result.getTimestamp("datetime").getTime());
                this.actions.add(ua);
            }
            this.close(result);
            this.close((Statement)sql);
        }
        catch (SQLException ex) {
            this.log.error("Error accessing database: ", (Throwable)ex);
        }
    }

    private void checkTable(String table) throws SQLException {
        boolean tableFound = this.findTable(table);
        if (!tableFound) {
            this.log.debug("Table '{}' not found, creating now!", (Object)table);
            this.createTable(table);
            if (!this.findTable(table)) {
                this.log.error("Unknown error creating table '{}'", (Object)table);
                throw new SQLException("Could not find or create table '" + table + "'");
            }
        }
    }

    private boolean findTable(String table) throws SQLException {
        boolean tableFound = false;
        DatabaseMetaData meta = this.dbConnection().getMetaData();
        ResultSet result = meta.getTables(null, null, null, null);
        while (result.next() && !tableFound) {
            if (!result.getString("TABLE_NAME").equalsIgnoreCase(table)) continue;
            tableFound = true;
        }
        this.close(result);
        return tableFound;
    }

    private void createTable(String table) throws SQLException {
        if (table.equals(NOTIFICATIONS_TABLE)) {
            Statement sql = this.dbConnection().createStatement();
            sql.execute("CREATE TABLE " + NOTIFICATIONS_TABLE + "(id INTEGER NOT NULL GENERATED ALWAYS AS " + "IDENTITY (START WITH 1, INCREMENT BY 1), " + "block CHAR(1) NOT NULL, " + "message VARCHAR(4000) NOT NULL, " + "datetime TIMESTAMP NOT NULL, " + "PRIMARY KEY (id))");
            this.close(sql);
            return;
        }
        throw new SQLException("Unknown table '" + table + "' requested!");
    }

    private void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing result set: ", (Throwable)ex);
            }
        }
        resultSet = null;
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing statement: ", (Throwable)ex);
            }
        }
        statement = null;
    }

    static /* synthetic */ void access$000(HouseKeeper x0) {
        x0.onTimeout();
    }
}

