/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.MessagingServices;
import com.googlecode.fascinator.portal.HouseKeeper;
import com.googlecode.fascinator.portal.UserAction;
import com.googlecode.fascinator.portal.services.HouseKeepingManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HouseKeepingManagerImpl
implements HouseKeepingManager {
    private Logger log = LoggerFactory.getLogger(HouseKeepingManagerImpl.class);
    private JsonSimpleConfig sysConfig;
    private HouseKeeper houseKeeper;
    private MessagingServices services;

    public HouseKeepingManagerImpl() {
        try {
            this.services = MessagingServices.getInstance();
            this.sysConfig = new JsonSimpleConfig();
            JsonObject object = this.sysConfig.getObject(new Object[]{"portal", "houseKeeping"});
            JsonSimpleConfig config = new JsonSimpleConfig();
            if (object != null) {
                JsonSimple json = new JsonSimple(object);
                config = new JsonSimpleConfig(json.toString());
            } else {
                this.log.warn("Invalid config for house keeping!");
            }
            this.houseKeeper = new HouseKeeper();
            this.houseKeeper.setPriority(10);
            this.houseKeeper.init(config);
            this.houseKeeper.start();
        }
        catch (IOException ex) {
            this.log.error("Failed to access system config", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error("Failed to start House Keeping", (Throwable)ex);
            this.houseKeeper = null;
        }
    }

    public void registryDidShutdown() {
        try {
            if (this.houseKeeper != null) {
                this.houseKeeper.stop();
            }
            this.services.release();
        }
        catch (Exception ex) {
            this.log.error("Error shutting down!", (Throwable)ex);
        }
    }

    @Override
    public List<UserAction> getUserMessages() {
        if (this.houseKeeper == null) {
            return new ArrayList<UserAction>();
        }
        return this.houseKeeper.getUserMessages();
    }

    @Override
    public void confirmMessage(String actionId) throws Exception {
        if (this.houseKeeper != null) {
            this.houseKeeper.confirmMessage(actionId);
        }
    }

    @Override
    public void sendMessage(String message) {
        this.services.queueMessage("houseKeeping", message);
    }

    @Override
    public void requestRestart() {
        this.log.info("System restart has been requested");
        JsonObject msg = new JsonObject();
        msg.put((Object)"type", (Object)"basic-restart");
        this.sendMessage(msg.toString());
    }

    @Override
    public void requestUrgentRestart() {
        this.log.info("Urgent system restart has been requested");
        JsonObject msg = new JsonObject();
        msg.put((Object)"type", (Object)"blocking-restart");
        this.sendMessage(msg.toString());
    }

    @Override
    public Map<String, Map<String, String>> getQueueStats() {
        if (this.houseKeeper != null) {
            return this.houseKeeper.getQueueStats();
        }
        return new LinkedHashMap<String, Map<String, String>>();
    }
}

