/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.servlet;

import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.GenericListener;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.BrokerMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.python.core.PySystemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerServlet
extends HttpServlet {
    public static final String DEFAULT_MESSAGING_HOME = FascinatorHome.getPath((String)"activemq-data");
    private Logger log = LoggerFactory.getLogger(IndexerServlet.class);
    private Timer timer;
    private List<GenericListener> messageQueues;
    private JsonSimpleConfig config;
    private BrokerMonitor monitor;
    private BrokerService broker;

    public void init() throws ServletException {
        try {
            this.config = new JsonSimpleConfig();
            String dataDir = this.config.getString(DEFAULT_MESSAGING_HOME, new Object[]{"messaging", "home"});
            this.broker = new BrokerService();
            this.broker.setDataDirectory(dataDir);
            this.broker.addConnector(this.config.getString("tcp://localhost:61616", new Object[]{"messaging", "url"}));
            String stompUrl = this.config.getString(null, new Object[]{"messaging", "stompUrl"});
            if (stompUrl != null) {
                this.broker.addConnector(stompUrl);
            }
            this.enableAMQStatistics(this.broker);
            this.broker.start();
        }
        catch (Exception e) {
            this.log.error("Failed to start broker: {}", (Throwable)e);
            throw new ServletException("Error starting AMQ Broker: ", (Throwable)e);
        }
        String realPath = this.getServletContext().getRealPath("/");
        if (!realPath.endsWith("/")) {
            realPath = realPath + "/";
        }
        String pythonHome = realPath + "WEB-INF/lib";
        Properties props = new Properties();
        props.setProperty("python.home", pythonHome);
        PySystemState.initialize((Properties)PySystemState.getBaseProperties(), (Properties)props, (String[])new String[]{""});
        PySystemState.add_classdir((String)(realPath + "WEB-INF/classes"));
        PySystemState.add_classdir((String)(realPath + "../../../target/classes"));
        PySystemState.add_extdir((String)pythonHome, (boolean)true);
        this.timer = new Timer("StartIndexer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                IndexerServlet.this.startIndexer();
            }
        }, 0L, 15000L);
    }

    private void enableAMQStatistics(BrokerService brokerService) {
        StatisticsBrokerPlugin statsPlugin = new StatisticsBrokerPlugin();
        BrokerPlugin[] aPlugins = brokerService.getPlugins();
        if (aPlugins == null) {
            aPlugins = new BrokerPlugin[]{};
        }
        ArrayList<Object> lPlugins = new ArrayList<Object>();
        lPlugins.addAll(Arrays.asList(aPlugins));
        lPlugins.add(statsPlugin);
        this.broker.setPlugins(lPlugins.toArray(aPlugins));
        this.broker.setEnableStatistics(true);
    }

    private void startIndexer() {
        this.log.info("Starting The Fascinator indexer...");
        if (this.messageQueues == null) {
            this.messageQueues = new ArrayList<GenericListener>();
        }
        List threadConfig = this.config.getJsonSimpleList(new Object[]{"messaging", "threads"});
        try {
            if (this.monitor == null) {
                this.monitor = new BrokerMonitor(this.broker);
                this.monitor.setPriority(9);
                this.monitor.start();
            }
            for (JsonSimple thread : threadConfig) {
                String classId = thread.getString(null, new Object[]{"id"});
                String priority = thread.getString(null, new Object[]{"priority"});
                if (classId != null) {
                    GenericListener queue = this.getListener(classId);
                    if (queue != null) {
                        if (priority != null) {
                            queue.setPriority(Integer.valueOf(priority).intValue());
                        }
                        queue.init(new JsonSimpleConfig(thread.toString()));
                        queue.start();
                        this.messageQueues.add(queue);
                        continue;
                    }
                    this.log.error("Failed to find Listener: '{}'", (Object)classId);
                    throw new Exception();
                }
                this.log.error("No message classId provided: '{}'", (Object)thread.toString());
                throw new Exception();
            }
            this.log.info("The Fascinator indexer was started successfully");
            this.timer.cancel();
            this.timer = null;
        }
        catch (Exception e) {
            this.log.warn("Message queues startup failed. Shutting them down...");
            for (GenericListener queue : this.messageQueues) {
                try {
                    queue.stop();
                }
                catch (Exception ex) {
                    this.log.error("Failed to stop listener '{}': {}", (Object)queue.getId(), (Object)ex.getMessage());
                }
            }
            this.messageQueues = null;
            this.log.warn("Will retry in 15 seconds.", (Throwable)e);
        }
    }

    private GenericListener getListener(String id) {
        ServiceLoader<GenericListener> listeners = ServiceLoader.load(GenericListener.class);
        for (GenericListener listener : listeners) {
            if (!id.equals(listener.getId())) continue;
            return listener;
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destroy() {
        try {
            this.broker.stop();
        }
        catch (Exception e) {
            this.log.error("Failed to stop message broker: {}", (Object)e.getMessage());
        }
        if (this.monitor != null) {
            this.monitor.stop();
        }
        if (this.messageQueues != null) {
            for (GenericListener queue : this.messageQueues) {
                try {
                    queue.stop();
                }
                catch (Exception e) {
                    this.log.error("Failed to stop listener '{}': {}", (Object)queue.getId(), (Object)e.getMessage());
                }
            }
        }
        if (this.timer != null) {
            this.timer.purge();
            this.timer = null;
        }
        super.destroy();
    }
}

