/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal;

import com.googlecode.fascinator.common.GenericListener;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class BrokerMonitor
implements GenericListener {
    public static final String QUEUE_ID = "BrokerMonitor";
    public static final String STATS_PREFIX = "ActiveMQ.Statistics.Destination";
    public static final long DEFAULT_TIMEOUT = 10L;
    public static final long AMQ_TIMEOUT = 500L;
    private Logger log = LoggerFactory.getLogger(BrokerMonitor.class);
    private JsonSimpleConfig globalConfig;
    private Connection connection;
    private Session pSession;
    private Session cSession;
    private Queue destStatsUpdate;
    private Queue destHouseKeeping;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private BrokerView monitor;
    private BrokerService broker;
    private Timer timer;
    private List<String> queues;
    private int numQueues = -1;
    private Map<String, Map<String, String>> stats;
    private List<String> statsOrder;
    private boolean statsReceived = false;
    private Map<String, Queue> targetQueues;
    private boolean firstRun = true;
    private Thread thread;

    public BrokerMonitor() {
    }

    public BrokerMonitor(BrokerService brokerService) throws Exception {
        this.log.info("Starting Broker Monitor...");
        this.broker = brokerService;
        this.monitor = this.broker.getAdminView();
        this.queues = new ArrayList();
        this.stats = new LinkedHashMap();
        this.targetQueues = new HashMap();
        this.thread = new Thread((Runnable)this, QUEUE_ID);
    }

    public void run() {
        try {
            this.globalConfig = new JsonSimpleConfig();
            String brokerUrl = this.globalConfig.getString("tcp://localhost:61616", new Object[]{"messaging", "url"});
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerUrl);
            this.connection = connectionFactory.createConnection();
            this.cSession = this.connection.createSession(false, 1);
            this.pSession = this.connection.createSession(false, 1);
            this.destStatsUpdate = this.cSession.createQueue(QUEUE_ID);
            this.consumer = this.cSession.createConsumer((Destination)this.destStatsUpdate);
            this.consumer.setMessageListener((MessageListener)this);
            this.destHouseKeeping = this.pSession.createQueue("houseKeeping");
            this.producer = this.pSession.createProducer(null);
            this.producer.setDeliveryMode(2);
            this.connection.start();
            this.statsOrder = new ArrayList();
            List qConfig = this.globalConfig.getJsonSimpleList(new Object[]{"messaging", "threads"});
            for (JsonSimple q : qConfig) {
                String name = q.getString(null, new Object[]{"config", "name"});
                if (name == null) continue;
                this.statsOrder.add(name);
            }
            this.log.info("Starting callback timer. Timeout = {}s", (Object)10L);
            this.startTimer();
        }
        catch (IOException ex) {
            this.log.error("Unable to read config!", (Throwable)ex);
        }
        catch (JMSException ex) {
            this.log.error("Error starting message thread!", (Throwable)ex);
        }
    }

    private void startTimer() {
        if (this.timer != null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer(QUEUE_ID, true);
        this.timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, 10000L);
    }

    public void init(JsonSimpleConfig config) throws Exception {
    }

    public void start() throws Exception {
        this.thread.start();
    }

    public String getId() {
        return QUEUE_ID;
    }

    private void onTimeout() {
        MDC.put((String)"name", (String)QUEUE_ID);
        boolean send = false;
        if (!Thread.currentThread().getName().equals(this.thread.getName())) {
            Thread.currentThread().setName(this.thread.getName());
            Thread.currentThread().setPriority(this.thread.getPriority());
        }
        if (this.monitor.getQueues().length != this.numQueues) {
            this.numQueues = this.monitor.getQueues().length;
            this.refreshQueues();
            send = true;
        }
        for (String q : this.queues) {
            this.updateStats(q);
        }
        if (!this.statsReceived) {
            this.startTimer();
            return;
        }
        if (this.firstRun) {
            this.firstRun = false;
            send = true;
        }
        JsonObject msgJson = new JsonObject();
        JsonObject queueStats = new JsonObject();
        for (String queue : this.stats.keySet()) {
            JsonObject thisQueue = new JsonObject();
            Map map = (Map)this.stats.get(queue);
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                thisQueue.put((Object)key, (Object)value);
                if (queue.equals("houseKeeping")) continue;
                if (key.equals("size") && !value.equals("0")) {
                    send = true;
                }
                if (!key.equals("change") || value.equals("0")) continue;
                send = true;
            }
            queueStats.put((Object)queue, (Object)thisQueue);
        }
        msgJson.put((Object)"stats", (Object)queueStats);
        if (send) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.log.warn("Sleep interrupted!");
            }
            try {
                msgJson.put((Object)"type", (Object)"broker-update");
                this.sendUpdate(msgJson.toString());
            }
            catch (JMSException ex) {
                this.log.error("Failed messaging House Keeping!", (Throwable)ex);
            }
        }
    }

    private void refreshQueues() {
        for (ObjectName object : this.monitor.getQueues()) {
            String rawData = ((Object)object).toString();
            String[] datums = rawData.split(",");
            if (datums.length == 3) {
                String queue = datums[2];
                if (queue.startsWith("Destination=")) {
                    if ((queue = queue.substring(12)).startsWith(STATS_PREFIX) || queue.equals(QUEUE_ID) || this.queues.contains(queue)) continue;
                    this.log.debug("New queue found: '{}'", (Object)queue);
                    this.queues.add(queue);
                    continue;
                }
                this.log.error("Unknown queue output format: '{}'", (Object)rawData);
                continue;
            }
            this.log.error("Unknown queue output string: '{}'", (Object)rawData);
        }
        ArrayList temp = new ArrayList();
        temp.addAll(this.queues);
        this.queues = new ArrayList();
        LinkedHashMap oldStats = new LinkedHashMap();
        oldStats.putAll(this.stats);
        this.stats = new LinkedHashMap();
        for (String q : this.statsOrder) {
            if (!temp.contains(q)) continue;
            this.queues.add(q);
            Map oldData = (Map)oldStats.get(q);
            if (oldData == null) {
                this.stats.put(q, new HashMap());
                continue;
            }
            this.stats.put(q, oldData);
        }
        for (String q : temp) {
            if (this.queues.contains(q)) continue;
            this.queues.add(q);
            Map oldData = (Map)oldStats.get(q);
            if (oldData == null) {
                this.stats.put(q, new HashMap());
                continue;
            }
            this.stats.put(q, oldData);
        }
    }

    private void updateStats(String queue) {
        try {
            String statsQueue = STATS_PREFIX + queue;
            if (!this.targetQueues.containsKey(statsQueue)) {
                this.targetQueues.put(statsQueue, this.pSession.createQueue(statsQueue));
            }
            Queue query = (Queue)this.targetQueues.get(statsQueue);
            Message msg = this.pSession.createMessage();
            msg.setJMSReplyTo((Destination)this.destStatsUpdate);
            this.producer.send((Destination)query, msg);
        }
        catch (JMSException ex) {
            this.log.error("Failed to send statistics update request", (Throwable)ex);
        }
    }

    public void stop() {
        this.log.info("Stopping Broker Monitor...");
        this.timer.cancel();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close producer: {}", (Throwable)jmse);
            }
        }
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close consumer: {}", (Throwable)jmse);
            }
        }
        if (this.cSession != null) {
            try {
                this.cSession.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close consumer session: {}", (Throwable)jmse);
            }
        }
        if (this.pSession != null) {
            try {
                this.pSession.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close consumer session: {}", (Throwable)jmse);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jmse) {
                this.log.warn("Failed to close connection: {}", (Throwable)jmse);
            }
        }
    }

    public void onMessage(Message message) {
        try {
            MapMessage reply;
            if (!Thread.currentThread().getName().equals(this.thread.getName())) {
                Thread.currentThread().setName(this.thread.getName());
                Thread.currentThread().setPriority(this.thread.getPriority());
            }
            if ((reply = (MapMessage)message) != null && reply.getMapNames().hasMoreElements()) {
                this.parseStats(reply);
            }
        }
        catch (JMSException jmse) {
            this.log.error("Failed to parse message: {}", (Object)jmse.getMessage());
        }
    }

    private void parseStats(MapMessage message) throws JMSException {
        String queue = message.getString("destinationName").replace("queue://", "");
        String memory = message.getString("memoryPercentUsage");
        String size = message.getString("size");
        String average = message.getString("averageEnqueueTime");
        int total = Integer.valueOf(message.getString("dequeueCount"));
        int target = Integer.valueOf(message.getString("enqueueCount"));
        int lost = -1 * (target - (total + Integer.valueOf(size)));
        if (queue != null) {
            int oldTotal;
            this.statsReceived = true;
            String oldTotalStr = (String)((Map)this.stats.get(queue)).get("total");
            if (oldTotalStr == null) {
                this.firstRun = true;
                oldTotal = 0;
            } else {
                oldTotal = Integer.valueOf(oldTotalStr);
            }
            int change = total - oldTotal;
            float speed = (float)change * 6.0f;
            HashMap<String, String> newData = new HashMap<String, String>();
            newData.put("size", size);
            newData.put("memory", memory);
            newData.put("average", average);
            newData.put("total", String.valueOf(total));
            newData.put("change", String.valueOf(change));
            newData.put("speed", String.valueOf(speed));
            newData.put("lost", String.valueOf(lost));
            this.stats.put(queue, newData);
        }
    }

    private void sendUpdate(String message) throws JMSException {
        TextMessage msg = this.pSession.createTextMessage(message);
        this.producer.send((Destination)this.destHouseKeeping, (Message)msg);
    }

    public void setPriority(int newPriority) {
        if (newPriority >= 1 && newPriority <= 10) {
            this.thread.setPriority(newPriority);
        }
    }

    static /* synthetic */ void access$000(BrokerMonitor x0) {
        x0.onTimeout();
    }
}

