/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.velocity;

import com.googlecode.fascinator.portal.velocity.JythonUberspect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.velocity.util.introspection.VelMethod;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonVelMethod
implements VelMethod {
    private Logger log = LoggerFactory.getLogger(JythonVelMethod.class);
    private String methodName;

    public JythonVelMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class getReturnType() {
        return Object.class;
    }

    public Object invoke(Object o, Object[] params) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("invoke:" + o);
            if (params != null) {
                for (Object param : params) {
                    this.log.trace("       param:" + param);
                }
            }
        }
        PyObject retVal = null;
        PyObject pyObject = (PyObject)o;
        PyObject method = pyObject.__findattr__(this.methodName);
        if (method != null) {
            this.log.trace("method:" + method);
            if (params == null || params.length < 1) {
                retVal = method.__call__();
            } else {
                ArrayList<Object> args = new ArrayList<Object>();
                for (Object param : params) {
                    if (param == null) {
                        return null;
                    }
                    this.log.trace("param:" + param + ":" + param.getClass());
                    if (param instanceof String) {
                        args.add(new PyString(param.toString()));
                        continue;
                    }
                    if (param instanceof Integer) {
                        args.add(new PyInteger(((Integer)param).intValue()));
                        continue;
                    }
                    if (param instanceof PyObject) {
                        args.add((PyObject)param);
                        continue;
                    }
                    if (param instanceof List) {
                        args.add(new PyList((Collection)((List)param)));
                        continue;
                    }
                    this.log.trace("Converting param type: {} to PyObject", (Object)param.getClass().getName());
                    args.add(Py.java2py((Object)param));
                }
                retVal = method.__call__(args.toArray(new PyObject[0]));
            }
        } else {
            this.log.debug("No such method: {}", (Object)this.methodName);
        }
        return JythonUberspect.toJava(retVal);
    }

    public boolean isCacheable() {
        return true;
    }
}

