/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.guitoolkit;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.guitoolkit.GUIFormRenderer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIFileUploader {
    private GUIFormRenderer fr;
    private Map<String, String> harvesters;
    private static Logger log = LoggerFactory.getLogger(GUIFileUploader.class);

    public GUIFileUploader(JsonSimpleConfig config, List<String> user_roles) {
        this.fr = new GUIFormRenderer(config);
        JsonObject object = config.getObject(new Object[]{"uploader"});
        Map workflows = JsonSimple.toJavaMap((JsonObject)object);
        this.harvesters = new LinkedHashMap<String, String>();
        for (String workflow : workflows.keySet()) {
            if (!((JsonSimple)workflows.get(workflow)).getString("", new Object[]{"upload-template"}).equals("")) continue;
            for (Object role : ((JsonSimple)workflows.get(workflow)).getArray(new Object[]{"security"})) {
                if (!user_roles.contains(role.toString())) continue;
                this.harvesters.put(workflow, ((JsonSimple)workflows.get(workflow)).getString(null, new Object[]{"screen-label"}));
            }
        }
    }

    public String renderForm() {
        if (this.harvesters.isEmpty()) {
            return "Sorry, but your current security permissions don't allow for file uploading.";
        }
        String form_string = "<form enctype='multipart/form-data' id='upload-file' method='post' action='workflow'>\n<fieldset class='login'>\n<legend>File Upload</legend>\n" + this.fr.ajaxFluidErrorHolder("upload-file") + "<p>\n" + this.fr.renderFormElement("upload-file-file", "file", "Select a file to upload:") + "</p>\n" + "<p>\n" + this.fr.renderFormSelect("upload-file-workflow", "Select the harvester to process the file:", this.harvesters) + "</p>\n" + "<div class='center'>" + this.fr.renderFormElement("upload-file-submit", "button", null, "Upload") + this.fr.ajaxProgressLoader("upload-file") + "</div>" + "</fieldset>\n" + "</form>\n";
        return form_string;
    }
}

